package com.mulesoft.weave.docs.model

import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

trait AnnotationCapableDocModel {

  def annotationCapableNode: AnnotationCapableNode

  def isAnnotatedWith(annotation: String): Boolean = {
    codeAnnotation(annotation).isDefined
  }

  def codeAnnotation(annotation: String): Option[AnnotationNode] = {
    annotationCapableNode.codeAnnotation(NameIdentifier(annotation))
  }

  def getSinceVersion: String = {
    codeAnnotation("Since") match {
      case Some(an) =>
        AnnotationNodeHelper.argString("version", an).getOrElse("")
      case None => ""
    }
  }
}