package com.mulesoft.weave.docs.model

import com.mulesoft.weave.docs.DocsGeneratorHelper.toValidContent
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.weavedoc.ExampleSectionNode
import org.mule.weave.v2.weavedoc.InputSectionNode
import org.mule.weave.v2.weavedoc.OutputSectionNode
import org.mule.weave.v2.weavedoc.SourceSectionNode

class ExampleSectionNodeDocModel(node: ExampleSectionNode) {

  lazy val description: String = {
    toValidContent(node.descriptionNode.map(_.literalValue).getOrElse(""))
  }

  def hasDescription: Boolean = {
    description.nonEmpty
  }

  lazy val sourceSection: String = {
    val source = getSectionWith(classOf[SourceSectionNode]).headOption.map(_.content.literalValue).getOrElse("")
    toValidContent(source)
  }

  def hasSourceSection: Boolean = {
    sourceSection.nonEmpty
  }

  lazy val sourceCodeBlockInfo: String = {
    getSectionWith(classOf[SourceSectionNode]).headOption.flatMap(_.content.info).map(_.literalValue).getOrElse("")
  }

  def hasSourceCodeBlockInfo: Boolean = {
    sourceCodeBlockInfo.nonEmpty
  }

  private def getSectionWith[T <: AstNode](classType: Class[T]): Seq[T] = {
    node.sections.filter(s => classType.isAssignableFrom(s.getClass)).map(classType.cast(_))
  }

  lazy val inputs: Array[CodeBlockWithDescriptionNodeDocModel] = {
    getSectionWith(classOf[InputSectionNode]).flatMap(i => i.content.map(c => CodeBlockWithDescriptionNodeDocModel(c))).toArray
  }

  def hasInputSection: Boolean = {
    inputs.nonEmpty
  }

  lazy val outputs: Array[CodeBlockWithDescriptionNodeDocModel] = {
    getSectionWith(classOf[OutputSectionNode]).flatMap(i => i.content.map(c => CodeBlockWithDescriptionNodeDocModel(c))).toArray
  }

  def hasOutputSection: Boolean = {
    outputs.nonEmpty
  }
}

object ExampleSectionNodeDocModel {
  def apply(node: ExampleSectionNode): ExampleSectionNodeDocModel = new ExampleSectionNodeDocModel(node)
}