#### _dw::core::runtime::Core_
__________________________________________

System Module
Defines all core functionality that all mapings will have autoimported

# Index

### Functions
| Name | Description|
|------|------------|
| [log](#log-index ) | Logs the specified `value` with the given `prefix` and returns the `value`. +<br>It is a identity function that as side effect log it out. +|
| [native](#native-index ) | Function used to load a native function using the specified identifier.|
| [now](#now-index ) | Returns the current DateTime|
| [random](#random-index ) | Returns a random value|
| [read](#read-index ) | Reads the content using the specified contentType and readerProperties|
| [readUrl](#readurl-index ) | |
| [write](#write-index ) | |




### Types
| Name | Description|
|------|------------|
|[CData](#cdata-index ) | |
|[Enum](#enum-index ) | |
|[Iterator](#iterator-index ) | |




### Annotations

| Name | Description|
|------|------------|
| [test](#test-index ) | |



__________________________________________


# Functions

## **log** [↑↑](#index )

### _log<T&#62;&#40;prefix: String = "", value: T&#41;: T_

Logs the specified `value` with the given `prefix` and returns the `value`. +
It is a identity function that as side effect log it out. +

#### Example:
```dataweave
%input payload application/json
%output application/xml
---
{ age: log("My Age", payload.age) }
```
Input:
```json
{ "age" : 33 }
```

This will print out: `My Age - 33`
#### Output:
```xml
<age>33</age>
```
__________________________________________


## **native** [↑↑](#index )

### _native<T&#62;&#40;identifier: String&#41;: T_

Function used to load a native function using the specified identifier.
__________________________________________


## **now** [↑↑](#index )

### _now&#40;&#41;: DateTime_

Returns the current DateTime
__________________________________________


## **random** [↑↑](#index )

### _random&#40;&#41;: Number_

Returns a random value
__________________________________________


## **read** [↑↑](#index )

### _read<T&#62;&#40;stringToParse: String, contentType: String = "application/dw", readerProperties: Object = {}&#41;: T_

Reads the content using the specified contentType and readerProperties

#### Example:
```dataweave
%output application/xml
---
read('{"name":"DataWeave"}', "application/json")
```

#### Output:
```xml
<name>DataWeave</name>
```
__________________________________________


## **readUrl** [↑↑](#index )

### _readUrl<T&#62;&#40;url: String, contentType: String = "application/dw", readerProperties: Object = {}&#41;: T_


__________________________________________


## **write** [↑↑](#index )

### _write&#40;value: Any, contentType: String = "application/dw", writerProperties: Object = {}&#41;: Any_


__________________________________________




__________________________________________

# Types

### **CData** [↑↑](#index )




#### Definition

```dataweave
String
```


### **Enum** [↑↑](#index )




#### Definition

```dataweave
String
```


### **Iterator** [↑↑](#index )




#### Definition

```dataweave
Array
```



__________________________________________

# Annotations

## **test** [↑↑](#index )



#### Annotation Definition

```dataweave
@test()
```


