#### _dw::core::runtime::Core_
__________________________________________

System Module
Defines all core functionality that all mapings will have autoimported

# Index

### Functions
| Name | Description|
|------|------------|
| [log](#log ) | Logs the specified `value` with the given `prefix` and returns the `value`. +<br>It is a identity function that as side effect log it out. +|
| [native](#native ) | Function used to load a native function using the specified identifier.|
| [now](#now ) | Returns the current DateTime|
| [random](#random ) | Returns a random value|
| [read](#read ) | Reads the content using the specified contentType and readerProperties|
| [readUrl](#readurl ) | |
| [write](#write ) | |




### Types
| Name | Description|
|------|------------|
|[CData](#cdata ) | |
|[Enum](#enum ) | |
|[Iterator](#iterator ) | |




### Annotations

| Name | Description|
|------|------------|
| [test](#test ) | |



__________________________________________


# Functions

## **log**

### _log<T&#62;&#40;prefix: String = "", value: T&#41;: T_

Logs the specified `value` with the given `prefix` and returns the `value`. +
It is a identity function that as side effect log it out. +

#### Example:
```dataweave
%input payload application/json
%output application/xml
---
{ age: log("My Age", payload.age) }
```
Input:
```json
{ "age" : 33 }
```

This will print out: `My Age - 33`
#### Output:
```xml
<age>33</age>
```
__________________________________________


## **native**

### _native<T&#62;&#40;identifier: String&#41;: T_

Function used to load a native function using the specified identifier.
__________________________________________


## **now**

### _now&#40;&#41;: DateTime_

Returns the current DateTime
__________________________________________


## **random**

### _random&#40;&#41;: Number_

Returns a random value
__________________________________________


## **read**

### _read<T&#62;&#40;stringToParse: String, contentType: String = "application/dw", readerProperties: Object = {}&#41;: T_

Reads the content using the specified contentType and readerProperties

#### Example:
```dataweave
%output application/xml
---
read('{"name":"DataWeave"}', "application/json")
```

#### Output:
```xml
<name>DataWeave</name>
```
__________________________________________


## **readUrl**

### _readUrl<T&#62;&#40;url: String, contentType: String = "application/dw", readerProperties: Object = {}&#41;: T_


__________________________________________


## **write**

### _write&#40;value: Any, contentType: String = "application/dw", writerProperties: Object = {}&#41;: Any_


__________________________________________




__________________________________________

# Types

### **CData**




#### Definition

```dataweave
String
```


### **Enum**




#### Definition

```dataweave
String
```


### **Iterator**




#### Definition

```dataweave
Array
```



__________________________________________

# Annotations

## **test**



#### Annotation Definition

```dataweave
@test()
```


