#### _dw::core::http::Types_
__________________________________________



# Index




### Types
| Name | Description|
|------|------------|
|[HARTimers](#hartimers-index ) | |
|[HttpClientOptionalOptions](#httpclientoptionaloptions-index ) | |
|[HttpClientOptions](#httpclientoptions-index ) | |
|[HttpClientRequest](#httpclientrequest-index ) | |
|[HttpClientRequiredOptions](#httpclientrequiredoptions-index ) | |
|[HttpClientResponse](#httpclientresponse-index ) | |
|[HttpClientResult](#httpclientresult-index ) | |
|[HttpHandler](#httphandler-index ) | |
|[HttpHeaders](#httpheaders-index ) | |
|[HttpResponseCookie](#httpresponsecookie-index ) | |
|[HttpResponseCookies](#httpresponsecookies-index ) | |
|[HttpServer](#httpserver-index ) | |
|[HttpServerOptions](#httpserveroptions-index ) | |
|[HttpServerRequest](#httpserverrequest-index ) | |
|[HttpServerResponse](#httpserverresponse-index ) | |
|[HttpStrictHeaders](#httpstrictheaders-index ) | |
|[QueryParams](#queryparams-index ) | |






__________________________________________





__________________________________________

# Types

### **HARTimers** [↑↑](#index )




#### Definition

```dataweave
{-| blocked?: Number, dns?: Number, connect?: Number, send?: Number, wait?: Number, receive?: Number, ssl?: Number, total: Number |-}
```


### **HttpClientOptionalOptions** [↑↑](#index )




#### Definition

```dataweave
{ headers?: HttpHeaders, body?: Any, /**
- Do we accept header redirections?
  -/
allowRedirect?: Boolean, /**
- Accept self signed server certificates
  -/
allowUnsafeSSL?: Boolean, readTimeout?: Number, connnectionTimeout?: Number,  // default 20000ms // default 10000ms
/**
- Should HTTP compression be used?
- If true, Accept-Encoding: gzip,deflate will be sent with request.
- If the server response with Content-Encoding: (gzip|deflate) the client will automatically handle decompression
- 
- This is true by default
  -/
allowCompression?: Boolean }
```


### **HttpClientOptions** [↑↑](#index )




#### Definition

```dataweave
HttpClientRequiredOptions & HttpClientOptionalOptions
```


### **HttpClientRequest** [↑↑](#index )




#### Definition

```dataweave
{ httpVersion: String, url: String, path: String, method: String, ip: String, port: Number, headers?: HttpStrictHeaders, payload?: Binary | String }
```


### **HttpClientRequiredOptions** [↑↑](#index )




#### Definition

```dataweave
{ /**
- Full url for the request, including domain
  -/
url: String, /**
- HTTP Method
  -/
method: String }
```


### **HttpClientResponse** [↑↑](#index )




#### Definition

```dataweave
{ /**
- Example: 200
  -/
status: Number, /**
- Example: "OK"
  -/
statusText: String, /**
- Response headers *
  -/
headers: HttpStrictHeaders, /**
- Response's raw body
  -/
payload?: Binary | String, /**
- If we can parse the body response
  -/
body?: Any, /**
- Get the parsed cookies from the "Set-Cookie" header *
  -/
cookies?: HttpResponseCookies, /**
- Content type header
  -/
contentType?: String, /**
- MIME type of the content type, without encoding
  -/
mime?: String }
```


### **HttpClientResult** [↑↑](#index )




#### Definition

```dataweave
{ err: Boolean, message?: String, options?: Object, request?: HttpClientRequest, /**
- Timing metrics, all values are accumulative except for ssl, it is included inside connect when available
  -/
timers?: HARTimers, response?: HttpClientResponse }
```


### **HttpHandler** [↑↑](#index )




#### Definition

```dataweave
(HttpServerRequest) -> HttpServerResponse
```


### **HttpHeaders** [↑↑](#index )




#### Definition

```dataweave
{ _?: SimpleType }
```


### **HttpResponseCookie** [↑↑](#index )




#### Definition

```dataweave
{ name: String, value: String, domain?: String, comment?: String, path?: String, maxAge?: Number, httpOnly?: Boolean, secure?: Boolean }
```


### **HttpResponseCookies** [↑↑](#index )




#### Definition

```dataweave
{ _?: HttpResponseCookie }
```


### **HttpServer** [↑↑](#index )




#### Definition

```dataweave
{| running: Boolean, port: Number, host: String, stop: () -> Boolean |}
```


### **HttpServerOptions** [↑↑](#index )




#### Definition

```dataweave
{ port: Number, host: String, contentType?: String }
```


### **HttpServerRequest** [↑↑](#index )




#### Definition

```dataweave
{ headers: HttpHeaders, method: String, path: String, queryParams: QueryParams, body: Any }
```


### **HttpServerResponse** [↑↑](#index )




#### Definition

```dataweave
{ headers?: HttpHeaders, body?: Any, status?: Number }
```


### **HttpStrictHeaders** [↑↑](#index )




#### Definition

```dataweave
{ _?: String }
```


### **QueryParams** [↑↑](#index )




#### Definition

```dataweave
{ _?: String }
```




