package com.mulesoft.weave.docs.model

import com.mulesoft.weave.docs.DocsGeneratorHelper.toValidContent
import org.mule.weave.v2.weavedoc.CodeBlockWithDescriptionNode

class CodeBlockWithDescriptionNodeDocModel(node: CodeBlockWithDescriptionNode) {
  lazy val description: String = {
    toValidContent(node.description.map(_.literalValue).getOrElse(""))
  }

  def hasDescription: Boolean = {
    description.nonEmpty
  }

  lazy val codeBlockInfo: String = {
    toValidContent(node.code.info.map(_.literalValue).getOrElse(""))
  }
  def hasCodeBlockInfo: Boolean = {
    codeBlockInfo.nonEmpty
  }

  lazy val codeContent: String = {
    toValidContent(node.code.content)
  }

}

object CodeBlockWithDescriptionNodeDocModel {
  def apply(node: CodeBlockWithDescriptionNode): CodeBlockWithDescriptionNodeDocModel = new CodeBlockWithDescriptionNodeDocModel(node)

}