package com.mulesoft.weave.docs.model

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective

class TypeDocModel(vd: TypeDirective) extends DocModel(vd.variable.name, vd) with AnnotationCapableDocModel {
  def label: String = vd.variable.name

  def definition: String = CodeGenerator.generate(vd.typeExpression)

  override def annotationCapableNode: AnnotationCapableNode = vd
}

object TypeDocModel {
  def apply(directive: TypeDirective): TypeDocModel = new TypeDocModel(directive)
}
