package com.mulesoft.weave.docs.model

import org.mule.weave.v2.parser.MessageCollector
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.CommentType
import org.mule.weave.v2.weavedoc.WeaveDocNode
import org.mule.weave.v2.weavedoc.WeaveDocParser

class DocModel(val name: String, val astNode: AstNode) {
  def documentation: String = {
    astNode.comments.find(_.commentType == CommentType.DocComment).map(_.literalValue).getOrElse("")
  }

  def reformatedDoc: String = {
    documentation
      .replaceAll("=== More Examples", "===== More Examples")
      .replaceAll("=== Example", "===== Example")
      .replaceAll("=== Parameters", "===== Parameters")
      .replaceAll("==== Source", "====== Source")
      .replaceAll("==== Output", "====== Output")
      .replaceAll("==== Input", "====== Input")
  }

  def description(): String = {
    val weaveDoc = astNode.weaveDoc
    val messageCollector = new MessageCollector
    val mayBeDoc: Option[WeaveDocNode] = weaveDoc.flatMap(doc => {
      WeaveDocParser.parseAst(doc.literalValue, messageCollector)
    })
    if (messageCollector.hasErrors()) {
      println("========================================================================")
      println(s"[Errors] ${messageCollector.errorMessages.size} errors while parsing documentation on: ${astNode.location().resourceName}")
      println("========================================================================")
      println(messageCollector.errorMessageString())
      println("========================================================================")
      println("")
      ""
    } else {
      mayBeDoc.flatMap(_.description).map(_.literalValue).getOrElse("")
    }
  }
}

object DocModel {
  def apply(name: String, astNode: AstNode): DocModel = new DocModel(name, astNode)
}