package com.mulesoft.weave.docs

import java.io.File

import org.mule.weave.v2.parser.DocumentParser
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.ParsingContextFactory
import org.mule.weave.v2.sdk.WeaveResourceFactory

object WeaveFileHelper {

  val WEAVE_FILE_EXTENSION = ".dwl"

  def collectWeaveFiles(baseDirectory: File, filterInternal: Boolean = false): Seq[File] = {
    val listFiles: Array[File] = baseDirectory.listFiles()
    if (listFiles != null) {
      listFiles.flatMap((file) => {
        if (file.isDirectory && (!filterInternal || !file.getName.equals("internal"))) {
          collectWeaveFiles(file)
        } else if (file.isFile) {
          if (file.getName.endsWith(WEAVE_FILE_EXTENSION)) {
            Seq(file)
          } else {
            Seq()
          }
        } else {
          Seq()
        }
      })
    } else {
      Seq()
    }
  }

  def parse(nameIdentifier: NameIdentifier, weaveFile: File): AstNode = {
    //We try to parse a mapping or a module
    val parser = new DocumentParser(15)
    val parsingContext = ParsingContextFactory.createParsingContext(nameIdentifier)
    val result = parser.parse(WeaveResourceFactory.fromFile(weaveFile), parsingContext)
    result.getResult().astNode
  }

  def isMapping(node: AstNode): Boolean = {
    node.isInstanceOf[DocumentNode]
  }

}
