package com.mulesoft.weave.docs.model

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode

class AnnotationDocModel(ad: AnnotationDirectiveNode)
    extends DocModel(ad.nameIdentifier.name, ad)
    with AnnotationCapableDocModel {

  def label: String = s"@${ad.nameIdentifier.name}(" + ad.params.paramList.map(apn => {
    apn.nameIdentifier.name + ": " + CodeGenerator.generate(apn.weaveType)
  }).mkString(", ") + ")"

  override def annotationCapableNode: AnnotationCapableNode = ad
}

object AnnotationDocModel {
  def apply(node: AnnotationDirectiveNode): AnnotationDocModel = new AnnotationDocModel(node)
}
