/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.it;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import junitx.framework.FileAssert;
import org.apache.commons.io.IOUtils;
import org.apache.maven.it.VerificationException;
import org.apache.maven.it.Verifier;
import org.apache.maven.it.util.ResourceExtractor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mule.weave.maven.plugin.it.SettingsConfigurator;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

public abstract class MojoITest
implements SettingsConfigurator {
    private static final String DATAWEAVE_MAVEN_PLUGIN_VERSION = "data.weave.maven.plugin.version";
    protected static final String TARGET_FOLDER_NAME = "target";
    protected static final String PROJECT_BASE_DIR_PROPERTY = "project.basedir";
    protected static final String PROJECT_BUILD_DIRECTORY_PROPERTY = "project.build.directory";
    protected static final String CLEAN = "clean";
    protected static final String COMPILE = "compile";
    protected static final String TEST = "test";
    protected static final String PACKAGE = "package";
    protected File projectBaseDirectory;
    protected Verifier verifier;
    protected File targetFolder;

    protected abstract String getResourcePath();

    protected boolean skipTests() {
        return true;
    }

    @Before
    public void initializeContext() throws IOException, VerificationException {
        this.projectBaseDirectory = ResourceExtractor.simpleExtractResources(this.getClass(), (String)this.getResourcePath());
        this.targetFolder = new File(this.projectBaseDirectory.getAbsolutePath(), TARGET_FOLDER_NAME);
        this.verifier = this.buildVerifier(this.projectBaseDirectory);
        this.verifier.addCliOption("-Dproject.basedir=" + this.projectBaseDirectory.getAbsolutePath());
        if (this.skipTests()) {
            this.verifier.addCliOption("-DskipTests");
        }
        this.verifier.setMavenDebug(true);
        String dataWeaveMavenPluginVersion = System.getProperty(DATAWEAVE_MAVEN_PLUGIN_VERSION);
        if (dataWeaveMavenPluginVersion != null) {
            this.verifier.setSystemProperty("dataWeaveMavenPluginVersion", dataWeaveMavenPluginVersion);
        }
        System.out.println("dataWeaveMavenPluginVersion: " + dataWeaveMavenPluginVersion);
    }

    @After
    public void after() {
        this.verifier.resetStreams();
    }

    protected void enableVerifierDebugMode() {
        this.verifier.setEnvironmentVariable("MAVEN_OPTS", "-agentlib:jdwp=transport=dt_socket,server=y,address=8002,suspend=y");
    }

    protected URI getResourceUri(String path) throws URISyntaxException {
        URL resource = MojoITest.class.getClassLoader().getResource(path);
        Assert.assertNotNull((String)("project not found at " + path), (Object)resource);
        return resource.toURI();
    }

    protected void verifyOutput(Path expectedOutputBasePath, Path outputBasePath) throws IOException {
        Files.walk(expectedOutputBasePath, new FileVisitOption[0]).forEach(expectedPath -> {
            if (Files.isRegularFile(expectedPath, new LinkOption[0])) {
                Path outputPath = outputBasePath.resolve(expectedOutputBasePath.relativize((Path)expectedPath));
                if (Files.exists(outputPath, new LinkOption[0])) {
                    System.out.println("Checking output file: " + expectedOutputBasePath.getParent().relativize((Path)expectedPath));
                    if (outputPath.toFile().getName().endsWith(".xml")) {
                        this.compareXml((Path)expectedPath, outputPath);
                    } else if (outputPath.toFile().getName().endsWith(".json")) {
                        this.compareJson((Path)expectedPath, outputPath);
                    } else if (!outputPath.endsWith("MANIFEST.MF")) {
                        this.compareChars((Path)expectedPath, outputPath);
                    }
                } else {
                    Assert.fail((String)("Expected file not found: " + outputPath));
                }
            }
        });
    }

    private void compareJson(Path expected, Path output) {
        try {
            JsonElement expectedJson = JsonParser.parseString((String)IOUtils.toString((URI)expected.toUri(), (Charset)StandardCharsets.UTF_8));
            JsonElement actualJson = JsonParser.parseString((String)IOUtils.toString((URI)output.toUri(), (Charset)StandardCharsets.UTF_8));
            Assert.assertEquals((Object)expectedJson, (Object)actualJson);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void compareXml(Path expected, Path output) {
        Diff d = DiffBuilder.compare((Object)Input.fromFile((File)expected.toFile())).withTest((Object)Input.fromFile((File)output.toFile())).ignoreComments().ignoreWhitespace().ignoreElementContentWhitespace().build();
        Assert.assertFalse((String)d.toString(), (boolean)d.hasDifferences());
    }

    private void compareChars(Path expected, Path output) {
        try {
            FileAssert.assertEquals((String)String.format("Comparison mismatch at resource %s: ", new File("test-classes").getAbsoluteFile().toPath().relativize(output)), (File)expected.toFile(), (File)output.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

