/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.it;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.maven.it.VerificationException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.weave.maven.plugin.helper.Files;
import org.mule.weave.maven.plugin.it.MojoITest;

public class WeavePackagerMojoITest
extends MojoITest {
    private static final String RESOURCE_PATH = "/data-weave-analytics";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setup() throws VerificationException {
        this.verifier.setSystemProperty("project.basedir", this.projectBaseDirectory.getAbsolutePath());
        this.verifier.setSystemProperty("project.build.directory", this.targetFolder.getAbsolutePath());
        this.verifier.executeGoal("clean");
    }

    @Test
    public void packageSuccessful() throws IOException, VerificationException, URISyntaxException {
        this.verifier.executeGoal("package");
        this.verifier.verifyErrorFreeLog();
        this.verifier.verifyFilePresent("target/data-weave-analytics-1.0.0-dw-library.jar");
        this.temporaryFolder.newFolder("output-jar");
        Path outputJarPath = Paths.get(this.targetFolder.getPath(), "data-weave-analytics-1.0.0-dw-library.jar");
        File outputFolder = this.createExtractionFolder("output-data-weave-analytics");
        Files.extractArchive(outputJarPath, outputFolder.toPath());
        Path expectedFolderPath = Paths.get(this.getResourceUri("expected-data-weave-analytics-package-structure" + File.separator + "data-weave-analytics-1.0.0-dw-library"));
        this.verifyOutput(expectedFolderPath, outputFolder.toPath());
    }

    private File createExtractionFolder(String path) throws IOException {
        File folder = this.temporaryFolder.newFolder(path);
        FileUtils.deleteDirectory((File)folder);
        return folder;
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_PATH;
    }
}

