#### _org::mule::weave::Statistics_
__________________________________________

This module provides a basic set of functionalities to analyze
datasets of values, numeric or not.

# Index

### Functions
| Name | Description|
|------|------------|
| [frequencies](#frequencies-index ) | The `frequencies` function returns the number of occurrences of each<br>distinct element on `values`.|
| [mean](#mean-index ) | The mean function returns the mean of an array of numbers,<br>or `null` if the array is empty.|
| [median](#median-index ) | The `median` function returns the point on the medium of the population.|
| [mode](#mode-index ) | The `mode` function returns the most common value on the array<br>of values.|
| [modes](#modes-index ) | The `modes` function returns the values with the most<br>number of occurrences.|
| [quantilesOf](#quantilesof-index ) | The `quantilesOf` function returns the points that separate the<br>values in `n` parts of equal size.|
| [stdev](#stdev-index ) | The `stdev` function returns the standard deviation of the<br>given set of values.|
| [variance](#variance-index ) | The `variance` function returns the variance of the given set of<br>values.|








__________________________________________


# Functions

## **frequencies** [↑↑](#index )

### _frequencies<T&#62;&#40;values: Array<T&#62;&#41;: Array<{ value: T, occurrences: Number }&#62;_

The `frequencies` function returns the number of occurrences of each
distinct element on `values`.

##### Parameters

| Name | Type | Description|
|------|------|------------|
| values | Array<T&#62; | |


##### Example

This example shows how the `frequencies` behaves under an array of numbers.

###### Source

```dataweave
%dw 2.0
output application/json

import frequencies from org::mule::weave::Statistics 
---
frequencies([1, 2, 11, 1, 1, 2])

```

###### Output

```json
[
  {value: 1, occurrences: 3},
  {value: 2, occurrences: 2},
  {value: 11, occurrences: 1}
]
```
__________________________________________


## **mean** [↑↑](#index )

### _mean&#40;values: Array<Number&#62;&#41;: Number &#124; Null_

The mean function returns the mean of an array of numbers,
or `null` if the array is empty.

##### Parameters

| Name | Type | Description|
|------|------|------------|
| values | Array<Number&#62; | |


##### Example

This example shows how the `mean` behaves over an array with numbers.

###### Source

```dataweave
%dw 2.0
output application/json

import mean from org::mule::weave::Statistics
---
mean([1, 2, 3, 4, 5])

```

###### Output

```json
3
```

##### Example

This example shows how the `mean` behaves under an empty array.

###### Source

```dataweave
%dw 2.0
output application/json

import mean from org::mule::weave::Statistics
---
mean([]) default "N/A"

```

###### Output

```json
"N/A"
```
__________________________________________


## **median** [↑↑](#index )

### _median&#40;values: Array<Number&#62;&#41;: Number &#124; Null_

The `median` function returns the point on the medium of the population.

If the length of the array is even, the average of the two medium points is returned.

##### Parameters

| Name | Type | Description|
|------|------|------------|
| values | Array<Number&#62; | |


##### Example

This example shows how the `median` behaves under different inputs.

###### Source

```dataweave
%dw 2.0
output application/json

import median from org::mule::weave::Statistics
---
median([3, 1, 4])

```

###### Output

```json
3
```
__________________________________________


## **mode** [↑↑](#index )

### _mode<T&#62;&#40;values: Array<T&#62;&#41;: T &#124; Null_

The `mode` function returns the most common value on the array
of values.

If there are more than one values with the most number of
occurrences, the first one will be returned.

##### Parameters

| Name | Type | Description|
|------|------|------------|
| values | Array<T&#62; | |


##### Example

This example shows how the `mode` behaves under an arbitrary array.

###### Source

```dataweave
%dw 2.0
output application/json

import mode from org::mule::weave::Statistics
---
mode(["hello", "world", "data", "weave", "data"])

```

###### Output

```json
"data"
```
__________________________________________


## **modes** [↑↑](#index )

### _modes<T&#62;&#40;values: Array<T&#62;&#41;: Array<T&#62;_

The `modes` function returns the values with the most
number of occurrences.

##### Parameters

| Name | Type | Description|
|------|------|------------|
| values | Array<T&#62; | |


##### Example

This example shows how the `modes` behaves under an arbitrary array.

###### Source

```dataweave
%dw 2.0
output application/json

import mode from org::mule::weave::Statistics
---
modes(["hello", "world", "data", "weave", "data", "hello"])

```

###### Output

```json
["hello", "data"]
```
__________________________________________


## **quantilesOf** [↑↑](#index )

### _quantilesOf&#40;n: Number, values: Array<Number&#62;&#41;: Array<Number&#62; &#124; Null_

The `quantilesOf` function returns the points that separate the
values in `n` parts of equal size.

If the middle point of two points is taken, it'll be taken doing
the average between both points.

##### Parameters

| Name | Type | Description|
|------|------|------------|
| values | Array<Number&#62; | |
| n | Number | |


##### Example

This example shows how the `quantilesOf` behaves under an arbitrary array.

###### Source

```dataweave
%dw 2.0
output application/json

import * from org::mule::weave::Statistics
---
3 quantilesOf [1, 2, 3, 4, 5]

```

###### Output

```json
[2, 4]
```
__________________________________________


## **stdev** [↑↑](#index )

### _stdev&#40;values: Array<Number&#62;&#41;: Number &#124; Null_

The `stdev` function returns the standard deviation of the
given set of values.

The standard deviation is defined as the square root
of the variance.

##### Parameters

| Name | Type | Description|
|------|------|------------|
| values | Array<Number&#62; | |


##### Example

This example shows how the `stdev` behaves under an arbitrary array.

###### Source

```dataweave
%dw 2.0
output application/json

import stdev from org::mule::weave::Statistics
---
stdev([1, 2, 3, 2])

```

###### Output

```json
0.7071067811865475244008443621048491
```
__________________________________________


## **variance** [↑↑](#index )

### _variance&#40;values: Array<Number&#62;&#41;: Number &#124; Null_

The `variance` function returns the variance of the given set of
values.

##### Parameters

| Name | Type | Description|
|------|------|------------|
| values | Array<Number&#62; | |


##### Example

This example shows how the `variance` behaves under an arbitrary array.

###### Source

```dataweave
%dw 2.0
output application/json

import variance from org::mule::weave::Statistics
---
variance([1, 2, 3, 2])

```

###### Output

```json
0.5
```
__________________________________________






