/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.it;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.it.VerificationException;
import org.junit.Before;
import org.junit.Test;
import org.mule.weave.maven.plugin.it.MojoITest;

public class WeaveDocsMojoITest
extends MojoITest {
    private static final String RESOURCE_PATH = "/data-weave-analytics";

    @Override
    protected String getResourcePath() {
        return RESOURCE_PATH;
    }

    @Before
    public void setup() throws VerificationException {
        this.verifier.setSystemProperty("project.basedir", this.projectBaseDirectory.getAbsolutePath());
        this.verifier.setSystemProperty("project.build.directory", this.targetFolder.getAbsolutePath());
        this.verifier.executeGoal("clean");
    }

    @Test
    public void generateExchangeMarkdownDoc() throws IOException, URISyntaxException, VerificationException {
        this.verifier.setSystemProperty("data.weave.doc.template", "exchange_markdown");
        this.verifier.executeGoal("data-weave:generate-docs");
        this.verifier.verifyErrorFreeLog();
        this.verifier.verifyFilePresent("target/data-weave-docs/exchange_markdown");
        Path markdownPath = Paths.get(this.targetFolder.getAbsolutePath(), "data-weave-docs", "exchange_markdown");
        Path expectedMarkdownPath = Paths.get(this.getResourceUri("expected-data-weave-analytics-data-weave-docs-structure" + File.separator + "data-weave-docs" + File.separator + "exchange_markdown"));
        this.verifyOutput(expectedMarkdownPath, markdownPath);
    }

    @Test
    public void generateAsciidoc() throws IOException, URISyntaxException, VerificationException {
        this.verifier.setSystemProperty("data.weave.doc.template", "asciidoc");
        this.verifier.executeGoal("data-weave:generate-docs");
        this.verifier.verifyErrorFreeLog();
        this.verifier.verifyFilePresent("target/data-weave-docs/asciidocs");
        Path asciidocPath = Paths.get(this.targetFolder.getAbsolutePath(), "data-weave-docs", "asciidocs");
        Path expectedAsciidocPath = Paths.get(this.getResourceUri("expected-data-weave-analytics-data-weave-docs-structure" + File.separator + "data-weave-docs" + File.separator + "asciidocs"));
        this.verifyOutput(expectedAsciidocPath, asciidocPath);
    }
}

