/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.it;

import java.util.List;
import java.util.Optional;
import org.apache.maven.it.VerificationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.weave.maven.plugin.it.MojoITest;

public class WeaveDependencyWarningsITest
extends MojoITest {
    private static final String RESOURCE_PATH = "/dependencies-warnings";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setup() throws VerificationException {
        this.verifier.setSystemProperty("project.basedir", this.projectBaseDirectory.getAbsolutePath());
        this.verifier.setSystemProperty("project.build.directory", this.targetFolder.getAbsolutePath());
        this.verifier.executeGoal("clean");
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_PATH;
    }

    @Test
    public void ignoreDependencyWarning() throws VerificationException {
        this.verifier.setSystemProperty("data.weave.compiler.logDependenciesWarnings", "false");
        this.verifier.executeGoal("compile");
        this.verifier.verifyErrorFreeLog();
        List logs = this.verifier.loadFile(this.verifier.getBasedir(), this.verifier.getLogFileName(), false);
        Optional<String> dependencyWarning = logs.stream().filter(log -> log.startsWith("[WARNING]") && log.contains("Warning.dwl")).findFirst();
        dependencyWarning.ifPresent(warning -> Assert.fail((String)("Test logged dependency warning: " + warning)));
    }

    @Test
    public void includeDependencyWarning() throws VerificationException {
        this.verifier.setSystemProperty("data.weave.compiler.logDependenciesWarnings", "true");
        this.verifier.executeGoal("compile");
        this.verifier.verifyErrorFreeLog();
        List logs = this.verifier.loadFile(this.verifier.getBasedir(), this.verifier.getLogFileName(), false);
        Optional<String> dependencyWarning = logs.stream().filter(log -> log.startsWith("[WARNING]") && log.contains("Warning.dwl")).findFirst();
        if (dependencyWarning.isEmpty()) {
            Assert.fail((String)"Didn't encounter warning generated by dependency");
        }
    }
}

