/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.it;

import org.apache.maven.it.VerificationException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.weave.maven.plugin.it.MojoITest;

public class WeaveCompileMojoITest
extends MojoITest {
    private static final String RESOURCE_PATH = "/data-weave-analytics";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setup() throws VerificationException {
        this.verifier.setSystemProperty("project.basedir", this.projectBaseDirectory.getAbsolutePath());
        this.verifier.setSystemProperty("project.build.directory", this.targetFolder.getAbsolutePath());
        this.verifier.executeGoal("clean");
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_PATH;
    }

    @Test
    public void compileSuccessful() throws VerificationException {
        this.verifier.executeGoal("compile");
        this.verifier.verifyErrorFreeLog();
        this.verifier.verifyTextInLog("DataWeave `data-weave-analytics` successfully compiled");
        this.verifier.verifyFilePresent("target/classes/org/mule/weave/Statistics.dwl");
        this.verifier.verifyFilePresent("target/classes/org/mule/weave/Statistics.bdwl");
        this.verifier.verifyFilePresent("target/classes/org/mule/weave/summaries/Common.dwl");
        this.verifier.verifyFilePresent("target/classes/org/mule/weave/summaries/Common.bdwl");
        this.verifier.verifyFilePresent("target/classes/org/mule/weave/summaries/CSVSummary.dwl");
        this.verifier.verifyFilePresent("target/classes/org/mule/weave/summaries/CSVSummary.bdwl");
        this.verifier.verifyFilePresent("target/classes/org/mule/weave/summaries/JsonSummary.dwl");
        this.verifier.verifyFilePresent("target/classes/org/mule/weave/summaries/JsonSummary.bdwl");
    }
}

