/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.helper;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Files {
    private Files() {
    }

    public static void extractArchive(Path archiveFile, Path destPath) throws IOException {
        java.nio.file.Files.createDirectories(destPath, new FileAttribute[0]);
        try (ZipFile archive = new ZipFile(archiveFile.toFile());){
            List entries = archive.stream().sorted(Comparator.comparing(ZipEntry::getName)).collect(Collectors.toList());
            for (ZipEntry entry : entries) {
                Path entryDest = destPath.resolve(entry.getName());
                if (entry.isDirectory()) {
                    java.nio.file.Files.createDirectory(entryDest, new FileAttribute[0]);
                    continue;
                }
                java.nio.file.Files.copy(archive.getInputStream(entry), entryDest, new CopyOption[0]);
            }
        }
    }
}

