/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mule.weave.maven.plugin.WeaveTestCommandlineExecutor;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;
import org.mule.weave.maven.plugin.helper.OSHelper;

public class WeaveTestCommandlineExecutorTest {
    private static MockedStatic<CommandLineUtils> commandLineUtilsMockedStatic;
    private MavenProject project;
    private Log log;
    private String classpath;
    private String[] args;
    private Map<String, String> environmentVariables;
    private Map<String, String> systemProperties;
    private String argLine;
    private boolean logForkedProcessCommand;
    private boolean jvmDebug;

    @BeforeClass
    public static void beforeClass() {
        commandLineUtilsMockedStatic = Mockito.mockStatic(CommandLineUtils.class);
    }

    @AfterClass
    public static void afterClass() {
        commandLineUtilsMockedStatic.close();
    }

    @Before
    public void setup() {
        this.project = (MavenProject)Mockito.mock(MavenProject.class);
        File baseDir = (File)Mockito.mock(File.class);
        Mockito.when((Object)baseDir.getAbsolutePath()).thenReturn((Object)"baseDir");
        Mockito.when((Object)this.project.getBasedir()).thenReturn((Object)baseDir);
        this.log = (Log)Mockito.mock(Log.class);
        this.classpath = "fake_classpath";
        this.args = new String[]{"arg1", "arg2"};
        this.environmentVariables = new HashMap<String, String>();
        this.environmentVariables.put("env_var1", "env_var1_value");
        this.environmentVariables.put("env_var2", "env_var2_value");
        this.systemProperties = new HashMap<String, String>();
        this.systemProperties.put("sp1", "sp1_value");
        this.systemProperties.put("sp2", "sp2_value");
        this.argLine = "argLineValue";
        this.logForkedProcessCommand = true;
        this.jvmDebug = true;
    }

    private WeaveTestCommandlineExecutor buildWeaveTestCommandlineExecutor() {
        WeaveTestMojoConfig mojoConfig = new WeaveTestMojoConfig();
        mojoConfig.setRunnerEnvironmentVariables(this.environmentVariables);
        mojoConfig.setRunnerSystemProperties(this.systemProperties);
        mojoConfig.setRunnerArgLine(this.argLine);
        mojoConfig.setRunnerLogForkedProcessCommand(this.logForkedProcessCommand);
        mojoConfig.setRunnerJvmDebug(this.jvmDebug);
        return new WeaveTestCommandlineExecutor(this.project, this.log, this.classpath, this.args, mojoConfig);
    }

    private void assertExecutorInstance(WeaveTestCommandlineExecutor executor) {
        MatcherAssert.assertThat((Object)executor, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)executor.getProject(), (Matcher)Matchers.is((Object)this.project));
        MatcherAssert.assertThat((Object)executor.getLog(), (Matcher)Matchers.is((Object)this.log));
        MatcherAssert.assertThat((Object)executor.getClasspath(), (Matcher)Matchers.is((Object)this.classpath));
        MatcherAssert.assertThat((Object)executor.getArgs(), (Matcher)Matchers.is((Object)this.args));
        MatcherAssert.assertThat((Object)executor.getMojoConfig().getRunnerEnvironmentVariables(), (Matcher)Matchers.is(this.environmentVariables));
        MatcherAssert.assertThat((Object)executor.getMojoConfig().getRunnerSystemProperties(), (Matcher)Matchers.is(this.systemProperties));
        MatcherAssert.assertThat((Object)executor.getMojoConfig().getRunnerArgLine(), (Matcher)Matchers.is((Object)this.argLine));
        MatcherAssert.assertThat((Object)executor.getMojoConfig().isRunnerLogForkedProcessCommand(), (Matcher)Matchers.is((Object)this.logForkedProcessCommand));
        MatcherAssert.assertThat((Object)executor.getMojoConfig().isRunnerJvmDebug(), (Matcher)Matchers.is((Object)this.jvmDebug));
    }

    @Test
    public void createWeaveTestRunnerExecutorSuccessful() {
        WeaveTestCommandlineExecutor executor = this.buildWeaveTestCommandlineExecutor();
        this.assertExecutorInstance(executor);
    }

    @Test
    public void failedCommandLineExecution() throws MojoFailureException, CommandLineException {
        Mockito.when((Object)CommandLineUtils.executeCommandLine((Commandline)((Commandline)ArgumentMatchers.any(Commandline.class)), (StreamConsumer)((StreamConsumer)ArgumentMatchers.any(StreamConsumer.class)), (StreamConsumer)((StreamConsumer)ArgumentMatchers.any(StreamConsumer.class)))).thenReturn((Object)1);
        WeaveTestCommandlineExecutor executor = (WeaveTestCommandlineExecutor)Mockito.spy((Object)this.buildWeaveTestCommandlineExecutor());
        ArgumentCaptor commandlineArgumentCaptor = ArgumentCaptor.forClass(Commandline.class);
        boolean result = executor.execute();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)false));
        ((WeaveTestCommandlineExecutor)Mockito.verify((Object)executor)).executeCommandLine((Commandline)commandlineArgumentCaptor.capture());
        MatcherAssert.assertThat((Object)commandlineArgumentCaptor.getValue(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String commandLineString = ((Commandline)commandlineArgumentCaptor.getValue()).toString();
        MatcherAssert.assertThat((Object)commandLineString, (Matcher)Matchers.is((Object)this.getExpectedCommandLine()));
    }

    @Test
    public void successCommandLineExecution() throws MojoFailureException, CommandLineException {
        Mockito.when((Object)CommandLineUtils.executeCommandLine((Commandline)((Commandline)ArgumentMatchers.any(Commandline.class)), (StreamConsumer)((StreamConsumer)ArgumentMatchers.any(StreamConsumer.class)), (StreamConsumer)((StreamConsumer)ArgumentMatchers.any(StreamConsumer.class)))).thenReturn((Object)0);
        WeaveTestCommandlineExecutor executor = (WeaveTestCommandlineExecutor)Mockito.spy((Object)this.buildWeaveTestCommandlineExecutor());
        ArgumentCaptor commandlineArgumentCaptor = ArgumentCaptor.forClass(Commandline.class);
        boolean result = executor.execute();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
        ((WeaveTestCommandlineExecutor)Mockito.verify((Object)executor)).executeCommandLine((Commandline)commandlineArgumentCaptor.capture());
        MatcherAssert.assertThat((Object)commandlineArgumentCaptor.getValue(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String commandLineString = ((Commandline)commandlineArgumentCaptor.getValue()).toString();
        MatcherAssert.assertThat((Object)commandLineString, (Matcher)Matchers.is((Object)this.getExpectedCommandLine()));
    }

    private String getExpectedCommandLine() {
        if (OSHelper.isWindowsOS()) {
            return "cmd.exe /X /C \"java -Dsp2=sp2_value -Dsp1=sp1_value -agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005 -Dbasedir=baseDir org.mule.weave.v2.module.test.runner.TestRunner arg1 arg2\"";
        }
        return "/bin/sh -c cd 'baseDir' && 'java' '-Dsp2=sp2_value' '-Dsp1=sp1_value' '-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005' '-Dbasedir=baseDir' 'org.mule.weave.v2.module.test.runner.TestRunner' 'arg1' 'arg2'";
    }
}

