/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.WeaveMojoTest;
import org.mule.weave.maven.plugin.WeaveTestMojo;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;

public class WeaveTestMojoTest
extends WeaveMojoTest {
    private static MockedStatic<CommandLineUtils> commandLineUtilsMockedStatic;
    private WeaveTestMojo mojo;

    @BeforeClass
    public static void beforeClass() {
        commandLineUtilsMockedStatic = Mockito.mockStatic(CommandLineUtils.class);
    }

    @AfterClass
    public static void afterClass() {
        commandLineUtilsMockedStatic.close();
    }

    @Before
    public void setup() {
        this.mojo = new WeaveTestMojo();
        this.configureMojo((AbstractWeaveMojo)this.mojo);
        WeaveTestMojoConfig config = new WeaveTestMojoConfig();
        config.setOutput(Paths.get(this.outputDirectory.getAbsolutePath(), "data-weave-test-reports").toFile());
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put("env_var1", "env_var1_value");
        environmentVariables.put("env_var2", "env_var2_value");
        config.setRunnerEnvironmentVariables(environmentVariables);
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        systemProperties.put("sp1", "sp1_value");
        systemProperties.put("sp2", "sp2_value");
        config.setRunnerSystemProperties(systemProperties);
        config.setRunnerArgLine("argLineValue");
        config.setRunnerLogForkedProcessCommand(true);
        config.setRunnerJvmDebug(true);
        this.mojo.config = config;
    }

    @Override
    public String getArtifactId() {
        return "ARTIFACT_ID";
    }

    @Test(expected=MojoExecutionException.class)
    public void failureTestExecution() throws MojoExecutionException, MojoFailureException, CommandLineException {
        Mockito.when((Object)CommandLineUtils.executeCommandLine((Commandline)((Commandline)ArgumentMatchers.any(Commandline.class)), (StreamConsumer)((StreamConsumer)ArgumentMatchers.any(StreamConsumer.class)), (StreamConsumer)((StreamConsumer)ArgumentMatchers.any(StreamConsumer.class)))).thenReturn((Object)1);
        this.mojo.execute();
    }

    @Test
    public void successTestExecution() throws MojoExecutionException, MojoFailureException, CommandLineException {
        Mockito.when((Object)CommandLineUtils.executeCommandLine((Commandline)((Commandline)ArgumentMatchers.any(Commandline.class)), (StreamConsumer)((StreamConsumer)ArgumentMatchers.any(StreamConsumer.class)), (StreamConsumer)((StreamConsumer)ArgumentMatchers.any(StreamConsumer.class)))).thenReturn((Object)0);
        this.mojo.execute();
    }
}

