/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;

public class WeaveTestCommandlineExecutor {
    private final MavenProject project;
    private final Log log;
    private final String classpath;
    private final String[] args;
    private final WeaveTestMojoConfig mojoConfig;

    public WeaveTestCommandlineExecutor(MavenProject project, Log log, String classpath, String[] args, WeaveTestMojoConfig mojoConfig) {
        this.project = project;
        this.log = log;
        this.classpath = classpath;
        this.args = args;
        this.mojoConfig = mojoConfig;
    }

    public boolean execute() throws MojoFailureException {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.project.getBasedir());
        cli.setExecutable("java");
        if (this.mojoConfig.getRunnerEnvironmentVariables() != null) {
            for (Map.Entry<String, String> entry : this.mojoConfig.getRunnerEnvironmentVariables().entrySet()) {
                cli.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
        cli.addEnvironment("CLASSPATH", this.classpath);
        if (this.mojoConfig.getRunnerSystemProperties() != null) {
            for (Map.Entry<String, String> entry : this.mojoConfig.getRunnerSystemProperties().entrySet()) {
                cli.createArg().setValue(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        if (this.mojoConfig.isRunnerJvmDebug()) {
            cli.createArg().setValue("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
        }
        cli.createArg().setValue(String.format("-Dbasedir=%s", this.project.getBasedir().getAbsolutePath()));
        if (this.mojoConfig.getRunnerArgLine() != null) {
            cli.createArg().setLine(this.mojoConfig.getRunnerArgLine());
        }
        cli.createArg().setValue("org.mule.weave.v2.module.test.runner.TestRunner");
        if (this.args != null) {
            for (String arg : this.args) {
                cli.createArg().setValue(arg);
            }
        }
        String commandLogStatement = "Running DW Command: " + cli;
        if (this.mojoConfig.isRunnerLogForkedProcessCommand()) {
            this.log.info((CharSequence)commandLogStatement);
        } else {
            this.log.debug((CharSequence)commandLogStatement);
        }
        try {
            int result = this.executeCommandLine(cli);
            return result == 0;
        }
        catch (CommandLineException e) {
            throw new MojoFailureException("Exception while executing forked process.", (Throwable)e);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Log getLog() {
        return this.log;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String[] getArgs() {
        return this.args;
    }

    public WeaveTestMojoConfig getMojoConfig() {
        return this.mojoConfig;
    }

    protected int executeCommandLine(Commandline cli) throws CommandLineException {
        StreamConsumer streamConsumer = System.out::println;
        return CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)streamConsumer, (StreamConsumer)streamConsumer);
    }
}

