/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.mule.weave.maven.plugin.exchange.exception.ClientException;

public abstract class RestClient {
    private static final String PATCH = "PATCH";
    private final boolean withMultiPartFeature;

    public RestClient(boolean withMultiPartFeature) {
        this.withMultiPartFeature = withMultiPartFeature;
    }

    public <T> Response post(String uri, String path, Entity<T> entity) {
        Response response = this.builder(uri, path).post(entity);
        this.checkResponseSuccessfulStatus(response);
        return response;
    }

    public <T> Response post(String uri, String path, T entity) {
        return this.post(uri, path, (T)Entity.json(entity));
    }

    public <T, U> U post(String uri, String path, T entity, Class<U> clazz) {
        return (U)this.post(uri, path, entity).readEntity(clazz);
    }

    public <T> Response put(String uri, String path, Entity<T> entity, Consumer<Invocation.Builder> requestCustomizer) {
        Invocation.Builder builder = this.builder(uri, path);
        requestCustomizer.accept(builder);
        Response response = builder.put(entity);
        this.checkResponseSuccessfulStatus(response);
        return response;
    }

    public <T> Response patch(String uri, String path, Entity<T> entity, Consumer<Invocation.Builder> requestCustomizer) {
        Invocation.Builder builder = this.builder(uri, path);
        requestCustomizer.accept(builder);
        builder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        Response response = builder.method(PATCH, entity);
        this.checkResponseSuccessfulStatus(response);
        return response;
    }

    public <T> Response patch(String uri, String path, T entity, Consumer<Invocation.Builder> requestCustomizer) {
        return this.patch(uri, path, (T)Entity.json(entity), requestCustomizer);
    }

    public Response patch(String uri, String path, Consumer<Invocation.Builder> requestCustomizer) {
        return this.patch(uri, path, (Object)null, requestCustomizer);
    }

    public String encodeUtf8(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkResponseSuccessfulStatus(Response response) throws ClientException {
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ClientException(response);
        }
    }

    private Invocation.Builder builder(String uri, String path) {
        Client client = ClientBuilder.newBuilder().build();
        if (this.withMultiPartFeature) {
            client.register(MultiPartFeature.class);
        }
        WebTarget target = client.target(uri).path(path);
        return target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }
}

