package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class WeaveTestMojoConfig {
    private File output;
    private boolean htmlReport = true;
    private boolean coverageEnabled = false;
    private CoverageConfig.CoverageFormat coverageFormat = CoverageConfig.CoverageFormat.sonar;
    private Map<String, String> runnerEnvironmentVariables = new HashMap<>();
    private Map<String, String> runnerSystemProperties = new HashMap<>();
    private String runnerArgLine;
    private boolean runnerLogForkedProcessCommand;
    private boolean runnerJvmDebug;
    
    public WeaveTestMojoConfig() {}
    
    public WeaveTestMojoConfig(File output) {
        this.output = output;
    }

    public File getOutput() {
        return output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public boolean isHtmlReport() {
        return htmlReport;
    }

    public void setHtmlReport(boolean htmlReport) {
        this.htmlReport = htmlReport;
    }

    public boolean isCoverageEnabled() {
        return coverageEnabled;
    }

    public void setCoverageEnabled(boolean coverageEnabled) {
        this.coverageEnabled = coverageEnabled;
    }

    public CoverageConfig.CoverageFormat getCoverageFormat() {
        return coverageFormat;
    }

    public void setCoverageFormat(CoverageConfig.CoverageFormat coverageFormat) {
        this.coverageFormat = coverageFormat;
    }

    public Map<String, String> getRunnerEnvironmentVariables() {
        return runnerEnvironmentVariables;
    }

    public void setRunnerEnvironmentVariables(Map<String, String> runnerEnvironmentVariables) {
        this.runnerEnvironmentVariables = runnerEnvironmentVariables;
    }

    public Map<String, String> getRunnerSystemProperties() {
        return runnerSystemProperties;
    }

    public void setRunnerSystemProperties(Map<String, String> runnerSystemProperties) {
        this.runnerSystemProperties = runnerSystemProperties;
    }

    public String getRunnerArgLine() {
        return runnerArgLine;
    }

    public void setRunnerArgLine(String runnerArgLine) {
        this.runnerArgLine = runnerArgLine;
    }

    public boolean isRunnerLogForkedProcessCommand() {
        return runnerLogForkedProcessCommand;
    }

    public void setRunnerLogForkedProcessCommand(boolean runnerLogForkedProcessCommand) {
        this.runnerLogForkedProcessCommand = runnerLogForkedProcessCommand;
    }

    public boolean isRunnerJvmDebug() {
        return runnerJvmDebug;
    }

    public void setRunnerJvmDebug(boolean runnerJvmDebug) {
        this.runnerJvmDebug = runnerJvmDebug;
    }
}
