package org.mule.weave.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import java.io.File;

public abstract class WeaveDocsMojo extends AbstractWeaveMojo {

    @Parameter(name = "docs")
    protected WeaveDocsMojoConfig config;
    
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
         init();
         doExecute();
    }

    private void init() {
        if (config == null) {
            config = new WeaveDocsMojoConfig(getDefaultOutputDirectory());
        }
        
        if (config.getOutput() == null) {
            config.setOutput(getDefaultOutputDirectory());
        }
    }

    protected abstract void doExecute() throws MojoExecutionException;
    
    private File getDefaultOutputDirectory() {
        return new File(project.getBuild().getDirectory() + File.separator + "data-weave-docs");
    }
    
    public void setDocs(WeaveDocsMojoConfig config) {
        this.config = config;
    }
}
