/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.WeaveMojoTest;
import org.mule.weave.maven.plugin.WeavePackagerMojo;
import org.mule.weave.maven.plugin.helper.ArtifactHandlerManagerBuilder;

public class WeavePackagerMojoTest
extends WeaveMojoTest {
    private static final String SIMPLE_DW_MODULE = "simple-dw-module";
    private WeavePackagerMojo mojo;

    @Override
    public String getArtifactId() {
        return SIMPLE_DW_MODULE;
    }

    @Before
    public void setup() {
        this.mojo = new WeavePackagerMojo();
        this.configureMojo((AbstractWeaveMojo)this.mojo);
        this.mojo.outputDirectory = this.outputDirectory;
        this.mojo.finalName = SIMPLE_DW_MODULE;
        this.mojo.classesDirectory = this.classesDirectory;
        HashMap<String, JarArchiver> archivers = new HashMap<String, JarArchiver>();
        archivers.put("jar", new JarArchiver());
        this.mojo.archivers = archivers;
        this.mojo.artifactHandlerManager = new ArtifactHandlerManagerBuilder().withJarArtifactHandler().build();
    }

    @Test
    public void packageSuccessful() throws IOException, MojoExecutionException {
        this.copyAssetSourceToTempFolder(Paths.get("src", "test", "resources", SIMPLE_DW_MODULE));
        this.mojo.execute();
        MatcherAssert.assertThat((Object)Paths.get(this.outputDirectory.getPath(), "simple-dw-module-dw-library.jar").toFile().exists(), (Matcher)Matchers.is((Object)true));
    }
}

