/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.Commandline;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;

public class WeaveTestCommandlineRequestBuilder {
    private final MavenProject project;
    private final String classpath;
    private final String[] args;
    private final WeaveTestMojoConfig mojoConfig;

    public WeaveTestCommandlineRequestBuilder(MavenProject project, String classpath, String[] args, WeaveTestMojoConfig mojoConfig) {
        this.project = project;
        this.classpath = classpath;
        this.args = args;
        this.mojoConfig = mojoConfig;
    }

    public Commandline build() {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.project.getBasedir());
        cli.setExecutable("java");
        if (this.mojoConfig.getRunnerEnvironmentVariables() != null) {
            for (Map.Entry<String, String> entry : this.mojoConfig.getRunnerEnvironmentVariables().entrySet()) {
                cli.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
        cli.addEnvironment("CLASSPATH", this.classpath);
        if (this.mojoConfig.getRunnerSystemProperties() != null) {
            for (Map.Entry<String, String> entry : this.mojoConfig.getRunnerSystemProperties().entrySet()) {
                cli.createArg().setValue(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        if (this.mojoConfig.isRunnerJvmDebug()) {
            cli.createArg().setValue("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
        }
        cli.createArg().setValue(String.format("-Dbasedir=%s", this.project.getBasedir().getAbsolutePath()));
        if (this.mojoConfig.getRunnerArgLine() != null) {
            cli.createArg().setLine(this.mojoConfig.getRunnerArgLine());
        }
        cli.createArg().setValue("org.mule.weave.v2.module.test.runner.TestRunner");
        if (this.args != null) {
            for (String arg : this.args) {
                cli.createArg().setValue(arg);
            }
        }
        return cli;
    }
}

