package org.mule.weave.maven.plugin;

import java.util.ArrayList;
import java.util.List;

/**
 * Provides internal utilities for the Mojo's operations.
 *
 * @author Jon-Anders Teigen
 */
final class MojoUtils {
    private MojoUtils() {}
    
    public static List<String> compoundArg(String name, String... strings) {
        List<String> list = new ArrayList<>();
        List<String> params = new ArrayList<>();
        for (String commaSeparated : strings) {
            params.addAll(splitOnComma(commaSeparated));
        }
        if (params.size() > 0) {
            list.add(name);
            String prefix = "";
            String a = "";
            for (String param : params) {
                a += prefix;
                a += param;
                prefix = " ";
            }
            list.add(a);
        }
        return list;
    }

    //
    // Splits a comma-delimited string.  Supports backslash escapes for
    // commas where string should not be split.  E.g. "a, b, c" returns
    // list ("a", "b", "c"), but "a\, b, c" returns ("a, b", "c").
    //
    public static List<String> splitOnComma(String cs) {
        List<String> args = new ArrayList<>();
        if (cs != null) {
            String[] split = cs.split("(?<!\\\\),");
            for (String arg : split) {
                args.add(arg.trim().replaceAll("\\\\,", ","));
            }
        }
        return args;
    }

    @SafeVarargs
    public static String[] concat(List<String>... lists) {
        List<String> c = new ArrayList<>();
        for (List<String> l : lists) {
            c.addAll(l);
        }
        return c.toArray(new String[0]);
    }
}