/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.Commandline;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.weave.maven.plugin.WeaveTestCommandlineRequestBuilder;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;
import org.mule.weave.maven.plugin.helper.OSHelper;

public class WeaveTestCommandlineRequestBuilderTest {
    private MavenProject project;
    private String classpath;
    private String[] args;
    private Map<String, String> environmentVariables;
    private Map<String, String> systemProperties;
    private String argLine;
    private boolean logForkedProcessCommand;
    private boolean jvmDebug;

    @Before
    public void setup() {
        this.project = (MavenProject)Mockito.mock(MavenProject.class);
        File baseDir = (File)Mockito.mock(File.class);
        Mockito.when((Object)baseDir.getAbsolutePath()).thenReturn((Object)"baseDir");
        Mockito.when((Object)this.project.getBasedir()).thenReturn((Object)baseDir);
        this.classpath = "fake_classpath";
        this.args = new String[]{"arg1", "arg2"};
        this.environmentVariables = new HashMap<String, String>();
        this.environmentVariables.put("env_var1", "env_var1_value");
        this.environmentVariables.put("env_var2", "env_var2_value");
        this.systemProperties = new HashMap<String, String>();
        this.systemProperties.put("sp1", "sp1_value");
        this.systemProperties.put("sp2", "sp2_value");
        this.argLine = "argLineValue";
        this.logForkedProcessCommand = true;
        this.jvmDebug = true;
    }

    @Test
    public void buildCommandlineSuccessfully() {
        WeaveTestMojoConfig mojoConfig = new WeaveTestMojoConfig();
        mojoConfig.setRunnerEnvironmentVariables(this.environmentVariables);
        mojoConfig.setRunnerSystemProperties(this.systemProperties);
        mojoConfig.setRunnerArgLine(this.argLine);
        mojoConfig.setRunnerLogForkedProcessCommand(this.logForkedProcessCommand);
        mojoConfig.setRunnerJvmDebug(this.jvmDebug);
        Commandline commandline = new WeaveTestCommandlineRequestBuilder(this.project, this.classpath, this.args, mojoConfig).build();
        String commandLineString = commandline.toString();
        MatcherAssert.assertThat((Object)commandLineString, (Matcher)Matchers.is((Object)this.getExpectedCommandLine()));
    }

    private String getExpectedCommandLine() {
        if (OSHelper.isWindowsOS()) {
            return "cmd.exe /X /C \"java -Dsp2=sp2_value -Dsp1=sp1_value -agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005 -Dbasedir=baseDir argLineValue org.mule.weave.v2.module.test.runner.TestRunner arg1 arg2\"";
        }
        return "/bin/sh -c cd 'baseDir' && 'java' '-Dsp2=sp2_value' '-Dsp1=sp1_value' '-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005' '-Dbasedir=baseDir' 'argLineValue' 'org.mule.weave.v2.module.test.runner.TestRunner' 'arg1' 'arg2'";
    }
}

