/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;

public class AbstractWeaveMojoTest {
    private TestAbstractWeaveMojo mojo;
    @Mock
    private MavenProject project;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.mojo = new TestAbstractWeaveMojo();
        this.mojo.project = this.project;
    }

    @Test
    public void testGetDeploymentRepositoryValidLegacySyntax() throws MojoFailureException {
        this.mojo.altDeploymentRepository = "myId::default::http://example.com/repo";
        DeploymentRepository result = this.mojo.getDeploymentRepository();
        Assert.assertEquals((Object)"myId", (Object)result.getId());
        Assert.assertEquals((Object)"http://example.com/repo", (Object)result.getUrl());
        Assert.assertEquals((Object)"default", (Object)result.getLayout());
    }

    @Test(expected=MojoFailureException.class)
    public void testGetDeploymentRepositoryInvalidLegacySyntax() throws MojoFailureException {
        this.mojo.altDeploymentRepository = "myId::invalid::http://example.com/repo";
        this.mojo.getDeploymentRepository();
    }

    @Test
    public void testGetDeploymentRepositoryValidNewSyntax() throws MojoFailureException {
        this.mojo.altDeploymentRepository = "myId::http://example.com/repo";
        DeploymentRepository result = this.mojo.getDeploymentRepository();
        Assert.assertEquals((Object)"myId", (Object)result.getId());
        Assert.assertEquals((Object)"http://example.com/repo", (Object)result.getUrl());
    }

    @Test(expected=MojoFailureException.class)
    public void testGetDeploymentRepositoryInvalidSyntax() throws MojoFailureException {
        this.mojo.altDeploymentRepository = "invalid_syntax";
        this.mojo.getDeploymentRepository();
    }

    private static class TestAbstractWeaveMojo
    extends AbstractWeaveMojo {
        private TestAbstractWeaveMojo() {
        }

        public void execute() {
        }
    }
}

