/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractWeaveMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.basedir}/src/main/dw", required=true, readonly=true)
    protected File sourceFolder;
    @Parameter(defaultValue="${project.basedir}/src/test/dw", required=true, readonly=true)
    protected File dwTestFolder;
    @Parameter(defaultValue="${project.basedir}/src/test/resources", required=true, readonly=true)
    protected File dwTestResources;
    @Parameter(property="altDeploymentRepository")
    protected String altDeploymentRepository;
    private static final Pattern ALT_LEGACY_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+?)::(.+)");
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+)");

    protected String buildTestClassPathEnvironment() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String e : this.testClasspathElements()) {
            if (first) {
                first = false;
            } else {
                buffer.append(File.pathSeparator);
            }
            buffer.append(e);
        }
        return buffer.toString();
    }

    protected List<String> compileClasspathElements() {
        try {
            return this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Dependency resolution should be test-scoped.", e);
        }
    }

    protected List<String> testClasspathElements() {
        try {
            return this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Dependency resolution should be test-scoped.", e);
        }
    }

    protected DeploymentRepository getDeploymentRepository() throws MojoFailureException {
        if (this.altDeploymentRepository != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + this.altDeploymentRepository));
            Matcher matcher = ALT_LEGACY_REPO_SYNTAX_PATTERN.matcher(this.altDeploymentRepository);
            if (matcher.matches()) {
                String id = matcher.group(1).trim();
                String layout = matcher.group(2).trim();
                String url = matcher.group(3).trim();
                if ("default".equals(layout)) {
                    this.getLog().warn((CharSequence)("Using legacy syntax for alternative repository. Use \"" + id + "::" + url + "\" instead."));
                    DeploymentRepository deploymentRepository = new DeploymentRepository();
                    deploymentRepository.setId(id);
                    deploymentRepository.setUrl(url);
                    deploymentRepository.setLayout(layout);
                    return deploymentRepository;
                }
                throw new MojoFailureException((Object)this.altDeploymentRepository, "Invalid legacy syntax and layout for repository.", "Invalid legacy syntax and layout for alternative repository. Use \"" + id + "::" + url + "\" instead, and only default layout is supported.");
            }
            matcher = ALT_REPO_SYNTAX_PATTERN.matcher(this.altDeploymentRepository);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)this.altDeploymentRepository, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::url\".");
            }
            String id = matcher.group(1).trim();
            String url = matcher.group(2).trim();
            DeploymentRepository deploymentRepository = new DeploymentRepository();
            deploymentRepository.setId(id);
            deploymentRepository.setUrl(url);
            return deploymentRepository;
        }
        return this.project.getDistributionManagement().getRepository();
    }
}

