/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;

public abstract class WeaveMojoTest {
    public static final String TARGET_FOLDER_NAME = "target";
    public static final String CLASSES_FOLDER_NAME = "classes";
    public static final String GROUP_ID = "org.mule.weave.data-weave-plugin";
    public static final String VERSION = "1.0.0";
    public static final String ORG_MULE_WEAVE = "org" + File.separator + "mule" + File.separator + "weave";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    protected File sourceFolder;
    protected File dwTestFolder;
    protected File dwTestResources;
    protected File outputDirectory;
    protected File classesDirectory;
    protected MavenProject project;
    protected MavenSession mavenSessionMock;
    protected Log logMock;
    protected List<String> compileClasspathElements = Arrays.stream(System.getProperty("java.class.path").split(System.getProperty("path.separator"))).filter(path -> path.contains(ORG_MULE_WEAVE)).collect(Collectors.toList());

    public abstract String getArtifactId();

    @Before
    public void setupWeaveMojoTest() throws IOException {
        this.mavenSessionMock = (MavenSession)Mockito.mock(MavenSession.class);
        this.sourceFolder = Paths.get(this.temporaryFolder.getRoot().getAbsolutePath(), "src", "main", "dw").toFile();
        this.dwTestFolder = Paths.get(this.temporaryFolder.getRoot().getAbsolutePath(), "src", "test", "dwtest").toFile();
        this.dwTestResources = Paths.get(this.temporaryFolder.getRoot().getAbsolutePath(), "src", "test", "resources").toFile();
        this.outputDirectory = this.temporaryFolder.newFolder(TARGET_FOLDER_NAME);
        this.clearOutput();
        this.classesDirectory = Paths.get(this.outputDirectory.getAbsolutePath(), CLASSES_FOLDER_NAME).toFile();
        Model model = new Model();
        model.setGroupId(GROUP_ID);
        model.setArtifactId(this.getArtifactId());
        model.setVersion(VERSION);
        model.setPackaging("dw-library");
        this.project = new MavenProject(model);
        this.project.setArtifact((Artifact)new ProjectArtifact(this.project));
        this.project.setFile(Paths.get(this.temporaryFolder.getRoot().getAbsolutePath(), "pom.xml").toFile());
        this.logMock = (Log)Mockito.mock(Log.class);
    }

    protected void configureMojo(AbstractWeaveMojo mojo) {
        mojo.setLog(this.logMock);
        mojo.sourceFolder = this.sourceFolder;
        mojo.dwTestFolder = this.dwTestFolder;
        mojo.dwTestResources = this.dwTestResources;
        mojo.project = this.project;
        mojo.session = this.mavenSessionMock;
    }

    protected void copyAssetSourceToTempFolder(Path source) throws IOException {
        FileUtils.copyDirectory((File)source.toFile(), (File)this.temporaryFolder.getRoot());
    }

    private void clearOutput() throws IOException {
        if (this.outputDirectory.exists()) {
            FileUtils.deleteDirectory((File)this.outputDirectory);
        }
    }
}

