/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.exchange;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.weave.maven.plugin.exchange.client.ExchangeClient;
import org.mule.weave.maven.plugin.exchange.client.MavenExchangeClientLogger;

public class ExchangeClientWireMockTest {
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(8080);
    private ExchangeClient exchangeClient;
    @Mock
    private MavenExchangeClientLogger logger;
    @Mock
    private MavenProject project;

    @Before
    public void testSetup() {
        MockitoAnnotations.initMocks((Object)this);
        this.exchangeClient = new ExchangeClient.Builder().withBaseAnypointUrl("http://localhost:8080").withUsername("testUser").withPassword("testPass").withLogger(this.logger).build();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/accounts/login")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"access_token\": \"mockedToken\"}")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/accounts/api/v2/oauth2/token")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"access_token\": \"mockedClientToken\"}")));
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*/portal/draft/pages/.*")).withHeader("Authorization", WireMock.equalTo((String)"bearer mockedToken")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.patch((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*")).withHeader("Authorization", WireMock.equalTo((String)"bearer mockedToken")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.patch((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*/portal")).withHeader("Authorization", WireMock.equalTo((String)"bearer mockedToken")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*/icon")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.patch((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*/portal")).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @Test
    public void testGetBearerTokenWithUsername() {
        String token = this.exchangeClient.getBearerToken();
        Assert.assertEquals((Object)"mockedToken", (Object)token);
        this.wireMockRule.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/accounts/login")).withRequestBody((ContentPattern)WireMock.containing((String)"\"username\":\"testUser\"")).withRequestBody((ContentPattern)WireMock.containing((String)"\"password\":\"testPass\"")));
    }

    @Test
    public void testGetBearerTokenWithClientCredentials() {
        ExchangeClient clientCredentialsClient = new ExchangeClient.Builder().withBaseAnypointUrl("http://localhost:8080").withUsername("~~~Client~~~").withPassword("clientId~?~clientSecret").withLogger(this.logger).build();
        String token = clientCredentialsClient.getBearerToken();
        Assert.assertEquals((Object)"mockedClientToken", (Object)token);
        this.wireMockRule.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/accounts/api/v2/oauth2/token")).withRequestBody((ContentPattern)WireMock.containing((String)"client_id=clientId")).withRequestBody((ContentPattern)WireMock.containing((String)"client_secret=clientSecret")).withRequestBody((ContentPattern)WireMock.containing((String)"grant_type=client_credentials")));
    }

    @Test
    public void testUploadPortalPages() throws Exception {
        File docsFolder = Files.createTempDirectory("docs", new FileAttribute[0]).toFile();
        File testFile = new File(docsFolder, "test.md");
        Files.write(testFile.toPath(), "Test content".getBytes(), new OpenOption[0]);
        Mockito.when((Object)this.project.getGroupId()).thenReturn((Object)"testGroup");
        Mockito.when((Object)this.project.getArtifactId()).thenReturn((Object)"testArtifact");
        Mockito.when((Object)this.project.getVersion()).thenReturn((Object)"1.0.0");
        Mockito.when((Object)this.project.getName()).thenReturn((Object)"Test Project");
        Mockito.when((Object)this.project.getDescription()).thenReturn((Object)"Test Description");
        this.exchangeClient.uploadPortalPages(docsFolder, this.project, Optional.empty());
        this.wireMockRule.verify(WireMock.putRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*/portal/draft/pages/.*")));
        this.wireMockRule.verify(WireMock.patchRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*")));
        this.wireMockRule.verify(WireMock.patchRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*/portal")));
    }

    @Test(expected=RuntimeException.class)
    public void testUploadDraftsWithInvalidFileName() throws Exception {
        File docsFolder = Files.createTempDirectory("docs", new FileAttribute[0]).toFile();
        File testFile = new File(docsFolder, "test@invalid.md");
        Files.write(testFile.toPath(), "Test content".getBytes(), new OpenOption[0]);
        this.exchangeClient.uploadDrafts(docsFolder, "testGroup", "testArtifact", "1.0.0");
    }

    @Test
    public void testUpdateAsset() {
        this.exchangeClient.updateAsset("testGroup", "testArtifact", "Test Name", "Test Description");
        this.wireMockRule.verify(WireMock.patchRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*")).withRequestBody((ContentPattern)WireMock.containing((String)"\"name\":\"Test Name\"")).withRequestBody((ContentPattern)WireMock.containing((String)"\"description\":\"Test Description\"")).withHeader("Authorization", WireMock.equalTo((String)"bearer mockedToken")));
    }

    @Test
    public void testUpdateFavicon() throws Exception {
        File faviconFile = File.createTempFile("favicon", ".png");
        Files.write(faviconFile.toPath(), "Fake image content".getBytes(), new OpenOption[0]);
        this.exchangeClient.updateFavicon("testGroup", "testArtifact", Optional.of(faviconFile));
        this.wireMockRule.verify(WireMock.putRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*/icon")).withHeader("Content-Type", WireMock.equalTo((String)"image/png")));
    }

    @Test
    public void testPublishPortal() {
        this.exchangeClient.publishPortal("testGroup", "testArtifact", "1.0.0");
        this.wireMockRule.verify(WireMock.patchRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/exchange/api/v2/assets/.*/portal")));
    }
}

