/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import com.mulesoft.weave.compiler.WeaveBinaryCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.ValidationPhase;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.message.ValidationMessage;
import org.mule.weave.v2.inspector.Inspector;
import org.mule.weave.v2.inspector.NoInspector$;
import org.mule.weave.v2.module.pojo.ClassLoaderServiceAware;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.ModuleLoader;
import org.mule.weave.v2.parser.phase.ModuleLoaderManager;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.parser.phase.ScopeGraphResult;
import org.mule.weave.v2.runtime.WeaveCompiler;
import org.mule.weave.v2.sdk.ChainedWeaveResourceResolver;
import org.mule.weave.v2.sdk.NameIdentifierHelper;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolverAware;
import org.mule.weave.v2.utils.AstEmitter;
import org.mule.weave.v2.utils.WeaveFile;
import org.mule.weave.v2.versioncheck.SVersion;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, executionStrategy="always")
@Execute(goal="compile")
public class WeaveCompileMojo
extends AbstractWeaveMojo {
    private static final String DW_EXTENSION = "dwl";
    @Parameter(defaultValue="PARSING", required=false, readonly=false)
    protected ValidationPhase mappingValidation = ValidationPhase.PARSING;
    @Parameter(defaultValue="FULL", required=false, readonly=false)
    protected ValidationPhase modulesValidation = ValidationPhase.PARSING;
    @Parameter(name="implicitInputs")
    protected List<String> implicitInputs = new ArrayList<String>();
    @Parameter(name="languageLevel")
    protected String languageLevel = null;
    @Parameter(name="logDependenciesWarnings", defaultValue="false")
    protected Boolean logDependenciesWarnings = false;
    @Parameter(name="binaryCompilation", defaultValue="false")
    protected Boolean binaryCompilation = false;
    @Parameter(name="checkDependenciesBinaryCompiled", defaultValue="false")
    protected Boolean checkDependenciesBinaryCompiled = false;
    @Parameter(name="disableCommonsSubExpressionElimination", defaultValue="false")
    protected Boolean disableCommonsSubExpressionElimination = false;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    private URL[] classpathUrls;
    private ClassLoaderResourceResolver classLoaderResourceResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException {
        this.getLog().info((CharSequence)String.format("Start Compiling DataWeave: `%s`", this.project.getName()));
        List<String> compileClasspathElements = super.compileClasspathElements();
        this.classpathUrls = (URL[])compileClasspathElements.stream().map(s -> {
            try {
                return new File((String)s).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        try (URLClassLoader resourceClassLoader = new URLClassLoader(this.classpathUrls, null);
             URLClassLoader serviceClassLoader = new URLClassLoader(this.classpathUrls, ModuleLoader.class.getClassLoader());){
            this.classLoaderResourceResolver = new ClassLoaderResourceResolver(resourceClassLoader);
            ChainedWeaveResourceResolver weaveResourceResolver = new ChainedWeaveResourceResolver(JavaConverters.collectionAsScalaIterable(Arrays.asList(new FolderResourceResolver(this.sourceFolder), this.classLoaderResourceResolver)).toSeq());
            Seq loaders = JavaConverters.collectionAsScalaIterable(Collections.singletonList(ModuleLoader.apply((WeaveResourceResolver)weaveResourceResolver))).toSeq();
            ModuleParsingPhasesManager moduleParsingPhasesManager = ModuleParsingPhasesManager.apply((ModuleLoaderManager)ModuleLoaderManager.apply((Seq)loaders, () -> {
                java.util.Iterator<ModuleLoader> iterator = ServiceLoader.load(ModuleLoader.class, serviceClassLoader).iterator();
                ArrayList<ModuleLoader> modules = new ArrayList<ModuleLoader>();
                while (iterator.hasNext()) {
                    ModuleLoader next = iterator.next();
                    if (next instanceof WeaveResourceResolverAware) {
                        ((WeaveResourceResolverAware)next).resolver((WeaveResourceResolver)weaveResourceResolver);
                    }
                    if (next instanceof ClassLoaderServiceAware) {
                        ((ClassLoaderServiceAware)next).classLoaderService(className -> {
                            try {
                                return Option.apply(resourceClassLoader.loadClass(className));
                            }
                            catch (ClassNotFoundException e) {
                                return Option.empty();
                            }
                        });
                    }
                    modules.add(next);
                }
                return JavaConverters.collectionAsScalaIterable(modules).toSeq();
            }));
            int numberOfError = this.validate(this.sourceFolder, "", moduleParsingPhasesManager);
            moduleParsingPhasesManager.invalidateAll();
            if (numberOfError > 0) {
                throw new MojoFailureException(String.format("Compilation failure %s errors found.", numberOfError));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.classLoaderResourceResolver = null;
        }
        this.getLog().info((CharSequence)String.format("DataWeave `%s` successfully compiled", this.project.getName()));
    }

    private int validate(File sourceDir, String name, ModuleParsingPhasesManager moduleParsingPhasesManager) {
        File[] child;
        int errors = 0;
        for (File file : child = Optional.ofNullable(sourceDir.listFiles()).orElse(new File[0])) {
            if (this.isDWFile(file)) {
                this.getLog().debug((CharSequence)String.format("Compiling %s", file.getAbsolutePath()));
                String basename = FilenameUtils.getBaseName((String)file.getName());
                errors += this.parse(NameIdentifier.apply((String)this.nameIdentifier(name, basename), (Option)Option.empty()), file, moduleParsingPhasesManager);
                continue;
            }
            if (!file.isDirectory()) continue;
            errors += this.validate(file, this.nameIdentifier(name, file.getName()), moduleParsingPhasesManager);
        }
        return errors;
    }

    private boolean isDWFile(File file) {
        return Optional.ofNullable(file).map(f -> DW_EXTENSION.equals(FilenameUtils.getExtension((String)f.getName()))).orElse(false);
    }

    private String nameIdentifier(String name, String moduleName) {
        if (name.isEmpty()) {
            return moduleName;
        }
        return name + NameIdentifier.SEPARATOR() + moduleName;
    }

    private int parse(NameIdentifier identifier, File file, ModuleParsingPhasesManager moduleParsingPhasesManager) {
        DocumentParser documentParser = new DocumentParser(15, (Inspector)NoInspector$.MODULE$);
        ParsingContext parsingContext = ParsingContextFactory.createParsingContext((NameIdentifier)identifier, (ModuleParsingPhasesManager)moduleParsingPhasesManager);
        for (String implicitInput : this.implicitInputs) {
            parsingContext.addImplicitInput(implicitInput, Option.empty());
        }
        if (this.languageLevel != null) {
            Option sVersionOption = SVersion.fromString((String)this.languageLevel);
            parsingContext.languageLevel_$eq(sVersionOption);
        }
        WeaveResource input = WeaveResourceFactory.fromFile((File)file);
        MessageCollector messages = this.compile(identifier, documentParser, input, file, parsingContext);
        Iterator errors = messages.errorMessages().toIterator();
        while (errors.hasNext()) {
            Tuple2 next = (Tuple2)errors.next();
            WeaveLocation weaveLocation = (WeaveLocation)next._1;
            try {
                this.getLog().error((CharSequence)String.format("%s: [%s, %s]\n%s at %s", file.getCanonicalPath(), weaveLocation.startPosition().line(), weaveLocation.startPosition().column(), ((Message)next._2).message(), weaveLocation.locationString()));
            }
            catch (IOException iOException) {}
        }
        Iterator warnings = messages.warningMessages().toIterator();
        while (warnings.hasNext()) {
            boolean messageFromDependency;
            Tuple2 next = (Tuple2)warnings.next();
            WeaveLocation weaveLocation = (WeaveLocation)next._1;
            File source = new File(this.sourceFolder, NameIdentifierHelper.toWeaveFilePath((NameIdentifier)weaveLocation.resourceName()));
            boolean bl = messageFromDependency = !source.exists();
            if (messageFromDependency && !Boolean.TRUE.equals(this.logDependenciesWarnings)) continue;
            try {
                this.getLog().warn((CharSequence)String.format("%s: [%s, %s]\n%s at %s", file.getCanonicalPath(), weaveLocation.startPosition().line(), weaveLocation.startPosition().column(), ((Message)next._2).message(), weaveLocation.locationString()));
            }
            catch (IOException iOException) {}
        }
        return messages.errorMessages().length();
    }

    private MessageCollector compile(NameIdentifier identifier, DocumentParser documentParser, WeaveResource input, File inputFile, ParsingContext parsingContext) {
        MessageCollector messages;
        PhaseResult parseResult = documentParser.parse(input, parsingContext);
        if (parseResult.hasResult()) {
            ParsingResult result = (ParsingResult)parseResult.getResult();
            if (result.astNode() instanceof ModuleNode) {
                if (this.modulesValidation == ValidationPhase.FULL) {
                    PhaseResult typeCheckingResultPhaseResult = documentParser.runAllPhases(input, parsingContext);
                    messages = typeCheckingResultPhaseResult.messages();
                } else {
                    messages = parseResult.messages();
                }
            } else if (this.mappingValidation == ValidationPhase.FULL) {
                PhaseResult typeCheckingResultPhaseResult = documentParser.runAllPhases(input, parsingContext);
                messages = typeCheckingResultPhaseResult.messages();
            } else {
                messages = parseResult.messages();
            }
            if (Boolean.TRUE.equals(this.binaryCompilation) && !messages.hasErrors()) {
                messages = this.binaryCompile(identifier, inputFile, input, result.astNode(), parsingContext);
            }
        } else {
            messages = parseResult.messages();
        }
        return messages;
    }

    private MessageCollector binaryCompile(NameIdentifier identifier, File inputFile, WeaveResource input, AstNode parserAstNode, ParsingContext parsingContext) {
        this.getLog().info((CharSequence)("Generating binary compilation file for resource: " + inputFile.getAbsolutePath()));
        MessageCollector messages = MessageCollector.apply();
        if (!this.classesDirectory.exists()) {
            messages.addErrorValidationMessage(new ValidationMessage((org.mule.weave.v2.api.tooling.message.Message)Message.apply((String)"BinaryCompilationMissingTargetFolder", (String)String.format("Could not generate binary compilation file for resource: %s due to classesDirectory doesn't exist: '%s'", inputFile.getAbsolutePath(), this.classesDirectory), () -> "Compilation"), (Location)parserAstNode.location()));
        } else {
            if (Boolean.TRUE.equals(this.disableCommonsSubExpressionElimination)) {
                parsingContext.disableCommonSubExpressionElimination();
            }
            if (parserAstNode instanceof ModuleNode) {
                PhaseResult preCompilationResultPhaseResult = WeaveCompiler.preCompileModule((WeaveResource)input, (ParsingContext)parsingContext);
                messages = preCompilationResultPhaseResult.messages();
                List<NameIdentifier> modulesWithoutBinaryCompilation = this.classLoaderResourceResolver.getModulesWithoutBinaryCompilation();
                if (Boolean.TRUE.equals(this.checkDependenciesBinaryCompiled) && !modulesWithoutBinaryCompilation.isEmpty()) {
                    messages.addErrorValidationMessage(new ValidationMessage((org.mule.weave.v2.api.tooling.message.Message)Message.apply((String)"BinaryCompilationMissingBinaryModuleDependency", (String)String.format("There was an error compiling to binary resource: '%s', it depends on modules: %s which are not binary compiled.", identifier, modulesWithoutBinaryCompilation), () -> "Compilation"), (Location)parserAstNode.location()));
                }
                if (!preCompilationResultPhaseResult.hasErrors() && preCompilationResultPhaseResult.hasResult()) {
                    AstNode compileNode = ((ScopeGraphResult)preCompilationResultPhaseResult.getResult()).astNode();
                    this.generateValidateBinaryFile(identifier, inputFile, input, compileNode, messages);
                }
            } else {
                PhaseResult preCompilationResultPhaseResult = WeaveCompiler.preCompile((WeaveResource)input, (ParsingContext)parsingContext);
                messages = preCompilationResultPhaseResult.messages();
                List<NameIdentifier> modulesWithoutBinaryCompilation = this.classLoaderResourceResolver.getModulesWithoutBinaryCompilation();
                if (Boolean.TRUE.equals(this.checkDependenciesBinaryCompiled) && !modulesWithoutBinaryCompilation.isEmpty()) {
                    messages.addErrorValidationMessage(new ValidationMessage((org.mule.weave.v2.api.tooling.message.Message)Message.apply((String)"BinaryCompilationMissingBinaryModuleDependency", (String)String.format("There was an error compiling to binary resource: '%s', it depends on modules: %s which are not binary compiled.", identifier, modulesWithoutBinaryCompilation.stream().map(NameIdentifier::name).collect(Collectors.joining(", ", "[", "]"))), () -> "Compilation"), (Location)parserAstNode.location()));
                }
                if (!preCompilationResultPhaseResult.hasErrors() && preCompilationResultPhaseResult.hasResult()) {
                    AstNode compileNode = ((ScopeGraphResult)preCompilationResultPhaseResult.getResult()).astNode();
                    this.generateValidateBinaryFile(identifier, inputFile, input, compileNode, messages);
                }
            }
        }
        return messages;
    }

    private void generateValidateBinaryFile(NameIdentifier identifier, File inputFile, WeaveResource input, AstNode compileNode, MessageCollector messages) {
        File binaryFile = WeaveBinaryCompiler.toBinary((AstNode)compileNode, (File)inputFile, (File)this.sourceFolder, (File)this.classesDirectory);
        AstNode deserializedNode = WeaveBinaryCompiler.toAstNode((File)binaryFile, (WeaveResource)input, (NameIdentifier)identifier);
        this.getLog().debug((CharSequence)("Validating binary compilation AST for input: " + inputFile.getAbsolutePath()));
        AstEmitter astEmitter = new AstEmitter(true, false, true, true);
        String deserializedAstNodeString = astEmitter.print(deserializedNode);
        String compiledNodeString = astEmitter.print(compileNode);
        if (!deserializedAstNodeString.equals(compiledNodeString)) {
            this.getLog().debug((CharSequence)("Compiled AST node: \n" + compiledNodeString));
            this.getLog().debug((CharSequence)("Binary deserialized compiled AST node: \n" + deserializedAstNodeString));
            messages.addErrorValidationMessage(new ValidationMessage((org.mule.weave.v2.api.tooling.message.Message)Message.apply((String)"BinaryCompilationDoNotMatchASTFromSource", (String)"The AST after being compiled to binary is not matching the AST from parsing phase. This is a bug.", () -> "Compilation"), (Location)compileNode.location()));
        }
    }

    private static class FolderResourceResolver
    implements WeaveResourceResolver {
        private final File sourceFolder;

        public FolderResourceResolver(File sourceFolder) {
            this.sourceFolder = sourceFolder;
        }

        public Option<WeaveResource> resolve(NameIdentifier name) {
            String weaveFilePath = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/");
            return this.resolvePath(weaveFilePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Option<WeaveResource> resolvePath(String path) {
            String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
            File resource = new File(this.sourceFolder, weaveFilePath);
            if (resource.exists()) {
                FileInputStream input = null;
                try {
                    input = new FileInputStream(resource);
                    String content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
                    Option option = Option.apply((Object)WeaveResourceFactory.fromContent((String)resource.toURI().toURL().toExternalForm(), (String)content));
                    return option;
                }
                catch (IOException e) {
                    Option option = Option.empty();
                    return option;
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            return Option.empty();
        }

        public Seq<WeaveResource> resolveAll(NameIdentifier name) {
            return this.resolve(name).toList();
        }
    }

    private static class ClassLoaderResourceResolver
    implements WeaveResourceResolver {
        private final URLClassLoader urlClassLoader;
        private List<NameIdentifier> missingBinaryCompiledModules = new ArrayList<NameIdentifier>();

        public ClassLoaderResourceResolver(URLClassLoader urlClassLoader) {
            this.urlClassLoader = urlClassLoader;
        }

        public Option<WeaveResource> resolve(NameIdentifier name) {
            String weaveFilePath = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/");
            this.checkBinaryCompiledFile(name, weaveFilePath);
            return this.resolvePath(weaveFilePath);
        }

        public Option<WeaveResource> resolvePath(String path) {
            String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
            Option<URL> maybeUrl = this.resolveUrl(weaveFilePath);
            return maybeUrl.map(WeaveResourceFactory::fromUrl);
        }

        private void checkBinaryCompiledFile(NameIdentifier name, String path) {
            String weaveFilePath;
            String string = weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
            if (this.resolveUrl(weaveFilePath.replace(WeaveFile.fileExtension(), WeaveFile.binaryFileExtension())).isEmpty()) {
                this.missingBinaryCompiledModules.add(name);
            }
        }

        private Option<URL> resolveUrl(String weaveFilePath) {
            return Option.apply((Object)this.urlClassLoader.getResource(weaveFilePath));
        }

        public List<NameIdentifier> getModulesWithoutBinaryCompilation() {
            return this.missingBinaryCompiledModules.stream().distinct().collect(Collectors.toList());
        }
    }
}

