/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.Commandline;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;

public class WeaveTestCommandlineRequestBuilder {
    private final MavenProject project;
    private final String classpath;
    private final String[] args;
    private final WeaveTestMojoConfig mojoConfig;

    public WeaveTestCommandlineRequestBuilder(MavenProject project, String classpath, String[] args, WeaveTestMojoConfig mojoConfig) {
        this.project = project;
        this.classpath = classpath;
        this.args = args;
        this.mojoConfig = mojoConfig;
    }

    public Commandline build() {
        String test;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.project.getBasedir());
        cli.setExecutable("java");
        this.setupEnvironmentVariables(cli);
        if (this.mojoConfig.getRunnerSystemProperties() != null) {
            for (Map.Entry<String, String> entry : this.mojoConfig.getRunnerSystemProperties().entrySet()) {
                cli.createArg().setValue(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        if ((test = System.getProperty("test")) != null) {
            cli.createArg().setValue(String.format("-D%s=%s", "testToRun", test));
        }
        if (this.mojoConfig.isRunnerJvmDebug()) {
            cli.createArg().setValue("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
        }
        cli.createArg().setValue(String.format("-Dbasedir=%s", this.project.getBasedir().getAbsolutePath()));
        if (this.mojoConfig.getRunnerArgLine() != null) {
            cli.createArg().setLine(this.mojoConfig.getRunnerArgLine());
        }
        cli.createArg().setValue("org.mule.weave.v2.module.test.runner.TestRunner");
        if (this.args != null) {
            for (String arg : this.args) {
                cli.createArg().setValue(arg);
            }
        }
        return cli;
    }

    private void setupEnvironmentVariables(Commandline cli) {
        if (this.mojoConfig.getRunnerEnvVarFile() != null && this.mojoConfig.getRunnerEnvVarFile().exists()) {
            try (InputStream is = Files.newInputStream(this.mojoConfig.getRunnerEnvVarFile().toPath(), new OpenOption[0]);){
                Properties properties = new Properties();
                properties.load(is);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    cli.addEnvironment(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Error reading envVarFile: " + String.valueOf(this.mojoConfig.getRunnerEnvVarFile()), ex);
            }
        }
        if (this.mojoConfig.getRunnerEnvironmentVariables() != null) {
            for (Map.Entry<String, String> entry : this.mojoConfig.getRunnerEnvironmentVariables().entrySet()) {
                cli.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
        cli.addEnvironment("CLASSPATH", this.classpath);
    }
}

