/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Before;
import org.junit.Test;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.WeaveCompileMojo;
import org.mule.weave.maven.plugin.WeaveMojoTest;
import org.mule.weave.v2.utils.WeaveFile;

public class WeaveCompileMojoTest
extends WeaveMojoTest {
    private static final String SIMPLE_DW_MAPPING = "simple-dw-mapping";
    private WeaveCompileMojo mojo;

    @Before
    public void setup() {
        this.mojo = new WeaveCompileMojo();
        this.configureMojo((AbstractWeaveMojo)this.mojo);
        this.mojo.classesDirectory = this.classesDirectory;
        this.mojo.project = new MavenProject(){

            public List<String> getCompileClasspathElements() {
                return WeaveCompileMojoTest.this.compileClasspathElements;
            }
        };
        MatcherAssert.assertThat((Object)this.mojo.classesDirectory.mkdirs(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Override
    public String getArtifactId() {
        return SIMPLE_DW_MAPPING;
    }

    @Test(expected=MojoFailureException.class)
    public void compilationExceptionTest() throws IOException, MojoFailureException {
        this.copyAssetSourceToTempFolder(Paths.get("src", "test", "resources", "compilation-failure-dw-mapping"));
        this.mojo.execute();
    }

    @Test
    public void compileSuccessful() throws IOException, MojoFailureException {
        this.copyAssetSourceToTempFolder(Paths.get("src", "test", "resources", SIMPLE_DW_MAPPING));
        this.mojo.execute();
    }

    @Test
    public void compileSuccessfulModule() throws IOException, MojoFailureException {
        this.copyAssetSourceToTempFolder(Paths.get("src", "test", "resources", "simple-dw-module-jsonschema"));
        this.mojo.execute();
    }

    @Test
    public void compileToBinarySuccessful() throws IOException, MojoFailureException {
        this.copyAssetSourceToTempFolder(Paths.get("src", "test", "resources", SIMPLE_DW_MAPPING));
        this.mojo.binaryCompilation = true;
        this.mojo.execute();
        Collection binaryCompiledFiles = FileUtils.listFiles((File)this.mojo.classesDirectory, (String[])new String[]{WeaveFile.binaryFileExtension().split("\\.")[1]}, (boolean)true);
        MatcherAssert.assertThat(binaryCompiledFiles.stream().map(File::getName).collect(Collectors.toList()), (Matcher)IsCollectionContaining.hasItem((Object)("Mapping" + WeaveFile.binaryFileExtension())));
    }
}

