/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.mule.weave.maven.plugin.WeaveDeployDocsMojo;
import org.mule.weave.maven.plugin.WeaveDocsMojoConfig;
import org.mule.weave.maven.plugin.exchange.client.ExchangeClient;

public class WeaveDeployDocsMojoTest {
    @Mock
    private SettingsDecrypter decrypter;
    @Mock
    private Settings settings;
    @Mock
    private MavenSession mavenSession;
    @Mock
    private ExchangeClient exchangeClient;
    private WeaveDeployDocsMojo mojo;
    private File exchangeOutputDoc;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.mojo = (WeaveDeployDocsMojo)Mockito.spy((Object)new WeaveDeployDocsMojo());
        this.mojo.decrypter = this.decrypter;
        this.exchangeOutputDoc = (File)Mockito.mock(File.class);
        Mockito.when((Object)this.exchangeOutputDoc.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.exchangeOutputDoc.getAbsolutePath()).thenReturn((Object)"/path/to/docs");
        this.mojo.config = new WeaveDocsMojoConfig(this.exchangeOutputDoc);
        this.mojo.session = this.mavenSession;
        Mockito.when((Object)this.mavenSession.getSettings()).thenReturn((Object)this.settings);
    }

    @Test
    public void testDoExecuteSkipDeployDocs() throws MojoFailureException {
        System.setProperty("skipDeployDocs", "true");
        this.mojo.doExecute();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo, (VerificationMode)Mockito.never())).getDeploymentRepository();
        System.clearProperty("skipDeployDocs");
    }

    @Test
    public void testDoExecuteDeploymentRepositoryFailure() throws MojoFailureException {
        ((WeaveDeployDocsMojo)Mockito.doThrow((Throwable[])new Throwable[]{new MojoFailureException("Repository failure")}).when((Object)this.mojo)).getDeploymentRepository();
        this.mojo.doExecute();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo)).getDeploymentRepository();
    }

    @Test
    public void testDoExecuteNonExchangeRepository() throws MojoFailureException {
        DeploymentRepository repository = new DeploymentRepository();
        repository.setUrl("https://non-exchange-repo.com");
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)repository).when((Object)this.mojo)).getDeploymentRepository();
        this.mojo.doExecute();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo)).getDeploymentRepository();
    }

    @Test
    public void testDoExecuteExchangeRepositoryNoServer() throws MojoFailureException {
        DeploymentRepository repository = new DeploymentRepository();
        repository.setUrl("https://maven.anypoint.mulesoft.com/api/v1/organizations/123/maven");
        repository.setId("exchange-server");
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)repository).when((Object)this.mojo)).getDeploymentRepository();
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)this.settings).when((Object)this.mojo)).loadDefaultUserSettings();
        Mockito.when((Object)this.settings.getServer(repository.getId())).thenReturn(null);
        this.mojo.doExecute();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo)).getDeploymentRepository();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo)).loadDefaultUserSettings();
    }

    @Test
    public void testDoExecuteExchangeRepositorySuccessfulDeploy() throws MojoFailureException {
        DeploymentRepository repository = new DeploymentRepository();
        repository.setUrl("https://maven.anypoint.mulesoft.com/api/v1/organizations/123/maven");
        repository.setId("exchange-server");
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)repository).when((Object)this.mojo)).getDeploymentRepository();
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)this.settings).when((Object)this.mojo)).loadDefaultUserSettings();
        Server server = new Server();
        server.setUsername("user");
        server.setPassword("pass");
        Mockito.when((Object)this.settings.getServer(repository.getId())).thenReturn((Object)server);
        SettingsDecryptionResult decryptionResult = (SettingsDecryptionResult)Mockito.mock(SettingsDecryptionResult.class);
        Mockito.when((Object)decryptionResult.getServer()).thenReturn((Object)server);
        Mockito.when((Object)this.decrypter.decrypt((SettingsDecryptionRequest)Mockito.any(DefaultSettingsDecryptionRequest.class))).thenReturn((Object)decryptionResult);
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)this.exchangeOutputDoc).when((Object)this.mojo)).getExchangeOutputDoc();
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)this.exchangeClient).when((Object)this.mojo)).createExchangeClient(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        this.mojo.doExecute();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo)).getDeploymentRepository();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo)).loadDefaultUserSettings();
        ((ExchangeClient)Mockito.verify((Object)this.exchangeClient)).uploadPortalPages((File)Mockito.eq((Object)this.exchangeOutputDoc), (MavenProject)Mockito.any(), (Optional)Mockito.any());
    }

    @Test
    public void testDoExecuteExchangeRepositoryNoDocsFolder() throws MojoFailureException {
        DeploymentRepository repository = new DeploymentRepository();
        repository.setUrl("https://maven.anypoint.mulesoft.com/api/v1/organizations/123/maven");
        repository.setId("exchange-server");
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)repository).when((Object)this.mojo)).getDeploymentRepository();
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)this.settings).when((Object)this.mojo)).loadDefaultUserSettings();
        Server server = new Server();
        Mockito.when((Object)this.settings.getServer(repository.getId())).thenReturn((Object)server);
        File exchangeOutputDoc = (File)Mockito.mock(File.class);
        Mockito.when((Object)exchangeOutputDoc.exists()).thenReturn((Object)false);
        ((WeaveDeployDocsMojo)Mockito.doReturn((Object)exchangeOutputDoc).when((Object)this.mojo)).getExchangeOutputDoc();
        this.mojo.doExecute();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo)).getDeploymentRepository();
        ((WeaveDeployDocsMojo)Mockito.verify((Object)this.mojo)).loadDefaultUserSettings();
        ((ExchangeClient)Mockito.verify((Object)this.exchangeClient, (VerificationMode)Mockito.never())).uploadPortalPages((File)Mockito.any(), (MavenProject)Mockito.any(), (Optional)Mockito.any());
    }

    @Test
    public void testLoadDefaultUserSettings() {
        Settings result = this.mojo.loadDefaultUserSettings();
        Assert.assertEquals((Object)this.settings, (Object)result);
    }

    @Test
    public void testDecrypt() {
        Server server = new Server();
        SettingsDecryptionResult decryptionResult = (SettingsDecryptionResult)Mockito.mock(SettingsDecryptionResult.class);
        Mockito.when((Object)decryptionResult.getServer()).thenReturn((Object)server);
        Mockito.when((Object)this.decrypter.decrypt((SettingsDecryptionRequest)Mockito.any(DefaultSettingsDecryptionRequest.class))).thenReturn((Object)decryptionResult);
        Server result = this.mojo.decrypt(server);
        Assert.assertEquals((Object)server, (Object)result);
    }
}

