/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.cli.Commandline;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.CommandLineRunner;
import org.mule.weave.maven.plugin.DefaultCommandLineRunner;
import org.mule.weave.maven.plugin.MojoUtils;
import org.mule.weave.maven.plugin.WeaveTestCommandlineRequestBuilder;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(goal="test")
public class WeaveTestMojo
extends AbstractWeaveMojo {
    @Parameter(name="tests")
    protected WeaveTestMojoConfig config;
    private CommandLineRunner commandLineRunner;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (System.getProperty("skipTests") != null) {
            this.getLog().warn((CharSequence)"Skipping Weave Tests.");
            return;
        }
        try {
            boolean success;
            this.init();
            ArrayList dwITArgs = new ArrayList();
            String classpath = this.buildTestClassPathEnvironment();
            String[] args = MojoUtils.concat(dwITArgs, this.testsDirectories(), this.reports(), this.coverage(), this.aggregators());
            Commandline commandline = new WeaveTestCommandlineRequestBuilder(this.project, classpath, args, this.config).build();
            String commandLogStatement = "Running DW Command: " + String.valueOf(commandline);
            if (this.config.isRunnerLogForkedProcessCommand()) {
                this.getLog().info((CharSequence)commandLogStatement);
            } else {
                this.getLog().debug((CharSequence)commandLogStatement);
            }
            int result = this.commandLineRunner.executeCommandLine(commandline);
            boolean bl = success = result == 0;
            if (!success) {
                throw new MojoFailureException("Tests Failed");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private void init() throws IOException {
        if (this.config == null) {
            this.config = new WeaveTestMojoConfig(this.getOutputFolder());
        }
        if (this.config.getOutput() == null) {
            this.config.setOutput(this.getOutputFolder());
        }
        if (this.dwTestFolder.getCanonicalFile().exists()) {
            if (this.config.getRunnerSystemProperties() == null) {
                this.config.setRunnerSystemProperties(new HashMap<String, String>());
            }
            this.config.getRunnerSystemProperties().put("dwtestDir", this.dwTestFolder.getCanonicalPath());
            this.config.getRunnerSystemProperties().put("dwtestResources", this.dwTestResources.getCanonicalPath());
        }
        if (this.commandLineRunner == null) {
            this.commandLineRunner = new DefaultCommandLineRunner();
        }
    }

    private File getOutputFolder() {
        return new File(this.project.getBuild().getDirectory() + File.separator + "data-weave-test-reports");
    }

    private List<String> testsDirectories() throws IOException {
        return MojoUtils.compoundArg("-R", this.dwTestFolder.getCanonicalPath());
    }

    private List<String> reports() throws IOException {
        return Arrays.asList("-r", "junit=" + this.config.getOutput().getCanonicalPath(), "-r", "json=" + this.config.getOutput().getCanonicalPath());
    }

    private List<String> coverage() throws IOException {
        if (this.config.isCoverageEnabled()) {
            return Arrays.asList("-coverage", this.sourceFolder.getPath(), "-coverageReport", String.valueOf((Object)this.config.getCoverageFormat()) + "=" + this.config.getOutput().getCanonicalPath() + "/coverage");
        }
        return Collections.emptyList();
    }

    private List<String> aggregators() throws IOException {
        return this.config.isHtmlReport() ? Arrays.asList("-a", "html=" + this.config.getOutput().getCanonicalPath()) : Collections.emptyList();
    }

    public void setTests(WeaveTestMojoConfig config) {
        this.config = config;
    }

    public void setCommandLineRunner(CommandLineRunner commandLineRunner) {
        this.commandLineRunner = commandLineRunner;
    }
}

