/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.WeaveDocsMojoConfig;
import org.mule.weave.maven.plugin.WeaveGenerateDocsMojo;
import org.mule.weave.maven.plugin.WeaveMojoTest;

public class WeaveGenerateDocsMojoTest
extends WeaveMojoTest {
    private static final String SIMPLE_DW_MODULE = "simple-dw-module";
    private static final String DATA_WEAVE_DOCS = "data-weave-docs";
    private File outputDocs;
    private WeaveGenerateDocsMojo mojo;

    @Before
    public void setup() {
        this.mojo = new WeaveGenerateDocsMojo();
        this.configureMojo((AbstractWeaveMojo)this.mojo);
        this.outputDocs = new File(this.outputDirectory, DATA_WEAVE_DOCS);
        WeaveDocsMojoConfig config = new WeaveDocsMojoConfig();
        config.setOutput(this.outputDocs);
        this.mojo.config = config;
    }

    @Override
    public String getArtifactId() {
        return SIMPLE_DW_MODULE;
    }

    @Test
    public void generateExchangeMarkdownDoc() throws IOException, MojoExecutionException, MojoFailureException {
        this.mojo.config.setTemplate("exchange_markdown");
        this.copyAssetSourceToTempFolder(Paths.get("src", "test", "resources", SIMPLE_DW_MODULE));
        this.mojo.execute();
        MatcherAssert.assertThat((Object)Paths.get(this.outputDocs.getPath(), "exchange_markdown").toFile().exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Paths.get(this.outputDocs.getPath(), "exchange_markdown", "home.md").toFile().exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Paths.get(this.outputDocs.getPath(), "exchange_markdown", "Module.md").toFile().exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void generateAsciiDoc() throws IOException, MojoExecutionException, MojoFailureException {
        this.mojo.config.setTemplate("asciidoc");
        this.copyAssetSourceToTempFolder(Paths.get("src", "test", "resources", SIMPLE_DW_MODULE));
        this.mojo.execute();
        MatcherAssert.assertThat((Object)Paths.get(this.outputDocs.getPath(), "asciidocs").toFile().exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Paths.get(this.outputDocs.getPath(), "asciidocs", "index.adoc").toFile().exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Paths.get(this.outputDocs.getPath(), "asciidocs", "acme", "Module.adoc").toFile().exists(), (Matcher)Matchers.is((Object)true));
    }
}

