/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.WeaveMojoTest;
import org.mule.weave.maven.plugin.WeaveTestMojo;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;

public class WeaveTestMojoTest
extends WeaveMojoTest {
    private WeaveTestMojo mojo;

    @Before
    public void setup() {
        this.mojo = new WeaveTestMojo();
        this.configureMojo((AbstractWeaveMojo)this.mojo);
        WeaveTestMojoConfig config = new WeaveTestMojoConfig();
        config.setOutput(Paths.get(this.outputDirectory.getAbsolutePath(), "data-weave-test-reports").toFile());
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put("env_var1", "env_var1_value");
        environmentVariables.put("env_var2", "env_var2_value");
        config.setRunnerEnvironmentVariables(environmentVariables);
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        systemProperties.put("sp1", "sp1_value");
        systemProperties.put("sp2", "sp2_value");
        config.setRunnerSystemProperties(systemProperties);
        config.setRunnerArgLine("argLineValue");
        config.setRunnerLogForkedProcessCommand(true);
        config.setRunnerJvmDebug(true);
        this.mojo.config = config;
    }

    @Override
    public String getArtifactId() {
        return "ARTIFACT_ID";
    }

    @Test(expected=MojoExecutionException.class)
    public void failureTestExecution() throws MojoExecutionException, MojoFailureException {
        this.mojo.setCommandLineRunner(cl -> 1);
        this.mojo.execute();
    }

    @Test
    public void successTestExecution() throws MojoExecutionException, MojoFailureException {
        this.mojo.setCommandLineRunner(cl -> 0);
        this.mojo.execute();
    }

    @Test
    public void sourceFolderTest() throws MojoExecutionException, MojoFailureException {
        this.mojo.sourceFolder = Paths.get(this.temporaryFolder.getRoot().getAbsolutePath(), "src", "main", "resources").toFile();
        this.mojo.config.setCoverageEnabled(true);
        this.mojo.setCommandLineRunner(cl -> {
            System.out.println("cl = " + String.valueOf(cl));
            Assert.assertTrue((boolean)cl.toString().contains("-coverage"));
            Assert.assertTrue((boolean)cl.toString().contains("src" + File.separator + "main" + File.separator + "resources"));
            return 0;
        });
        this.mojo.execute();
    }
}

