/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;

@Mojo(name="initialize", executionStrategy="always", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
@Execute(goal="initialize")
public class WeaveProjectInitializeMojo
extends AbstractWeaveMojo {
    @Parameter(property="maven.scala.useCanonicalPath", defaultValue="true")
    private boolean useCanonicalPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String path;
            this.getLog().debug((CharSequence)"Initializing DataWeave Maven Plugin...");
            if (this.sourceFolder != null && this.sourceFolder.exists() && this.resourceNotDefined(path = WeaveProjectInitializeMojo.pathOf(this.sourceFolder, this.useCanonicalPath), this.project.getResources())) {
                this.getLog().debug((CharSequence)String.format("Add Source directory: %s", path));
                Resource resource = new Resource();
                resource.setDirectory(path);
                this.project.addResource(resource);
            }
            if (this.dwTestFolder != null && this.dwTestFolder.exists()) {
                path = WeaveProjectInitializeMojo.pathOf(this.dwTestFolder, this.useCanonicalPath);
                this.defineTestResourceIfMissing(path);
            }
        }
        catch (Exception exc) {
            throw new MojoExecutionException("Error while running initialize.", exc);
        }
    }

    private void defineTestResourceIfMissing(String path) {
        List testResources = this.project.getTestResources();
        if (this.resourceNotDefined(path, testResources)) {
            this.getLog().debug((CharSequence)String.format("Add Test Source directory: %s", path));
            Resource testResource = new Resource();
            testResource.setDirectory(path);
            this.project.addTestResource(testResource);
        }
    }

    private boolean resourceNotDefined(String path, List<Resource> testResources) {
        return testResources.stream().noneMatch(r -> r.getDirectory().equals(path));
    }

    static String pathOf(File f, boolean canonical) throws Exception {
        return canonical ? f.getCanonicalPath() : f.getAbsolutePath();
    }
}

