%dw 2.0
import * from dw::test::Tests
import * from dw::core::Arrays
import * from dw::test::internal::reporter::Reports

input aggregatorInput: AggregatorInput application/json
output application/html with xml
---
html: {
    head: {
        meta @(charset: "utf-8") : null,
        meta @(name: "viewport", content:"width=device-width, initial-scale=1, maximum-scale=1") : null,
        title: "DataWeave Testing Framework - Test Report",
        link @(rel: "stylesheet", 'type': "text/css", href: "assets/mulesoft-styles.css"): null,
        link @(rel: "stylesheet", 'type': "text/css", href: "assets/tsorter.css"): null
    },
    body: {
        header: {
             div @(class:"mulesoft-topbar"): {
                div @(class: "mulesoft-appbar"): {
                        div @(class: "muleicon muleicon-logo"): null,
                        div @(class: "anypoint-brand"): "DataWeave Testing Framework - Test Report"
                    }
                }
            },
        div @(class: "col-md-2 col-md-offset-1 sidemenu"):{
            ul @(class: "sidemenu-back"):{
                li:{
                    a @(href: ""): "Test Report"
                },
                (if (aggregatorInput.showCoverageReport) {
                  li: {
                    a @(href: "coverage/data-weave-testing-framework-coverage-report.html"): "Coverage Report"
                  }
                } else {
                })
            }
        },
        div @(class: "container col-md-8"): {
            div @(class: "container-fluid"): {
                table @(class: "table table-featured table-hover sortable", id: "summary"): {
                    thead: {
                        tr: {
                                th @(colspan: "2", "data-tsorter":"link"): "Test Suite",
                                th @("data-tsorter": "numeric"): "Passed",
                                th @("data-tsorter": "numeric"): "Failed",
                                th @("data-tsorter": "numeric"): "Skipped",
                                th @("data-tsorter": "numeric"): "Total"
                        }
                    },
                    tbody: {
                        (aggregatorInput.testsResult map (testSuite) -> {
                                tr:{
                                    td @(colspan: "2"): {
                                        a @(href: "#$(testSuite.name)"): testSuite.name
                                    },
                                    td: totalOk(testSuite.testResult),
                                    td: totalFail(testSuite.testResult) + totalErrors(testSuite.testResult),
                                    td: totalSkip(testSuite.testResult),
                                    td: totalTests(testSuite.testResult)
                                }

                            }
                        )
                    }
                }
            },
            hr: null,
            (
                aggregatorInput.testsResult map (testSuite) -> {
                div @(class: "container-fluid"): {
                    h4 @(class: "text-bold", id: "$(testSuite.name)"): testSuite.name ++ "-" ++ testSuite.testResult.name,
                    h4 @(class: "margin-top-base margin-bottom-base"): {
                        span @(class: "text-info text-center col-md-3"): "Tests Executed: $(totalTests(testSuite.testResult))",
                        span @(class: "text-success text-center col-md-3"): "Tests Passed: $(totalOk(testSuite.testResult))",
                        span @(class: "text-danger text-center col-md-3"): "Tests Failed: $(totalFail(testSuite.testResult) + totalErrors(testSuite.testResult))",
                        span @(class: "text-warning text-center col-md-3"): "Tests Skipped: $(totalSkip(testSuite.testResult))"
                    },
                    table @(class: "table table-hover", id: "resources_table"): {
                        thead:{
                            tr: {
                                th @(class: "col-md-6") : "Test Name",
                                th @(class: "col-md-2"): "Result",
                                th @(class: "col-md-4"): "Failure Reason"
                            }
                        },
                        tbody @(id: "table-body") : {
                                    (
                                        testSuite.testResult.tests map ((test, index) ->
                                            if (test.status == OK_STATUS)
                                                tr: {
                                                    td @(class: "col-md-6"): test.name,
                                                    td @(class: "col-md-2"): {
                                                        div @(class: "container-fluid muleicon muleicon-head muleicon-success", style: "margin-left: 0px;"): null
                                                    },
                                                    td @(class: "col-md-4"): null

                                            } else if (test.status == FAIL_STATUS or test.status == ERROR_STATUS) {
                                                 tr : {
                                                     td @(class: "col-md-6"): test.name,
                                                     td @(class: "col-md-2"): {
                                                        div @(class: "container-fluid muleicon muleicon-head muleicon-fail", style: "margin-left: 0px;"): null
                                                     },
                                                     td @(class: "col-md-4"): test.errorMessage
                                                }
                                            } else {
                                                 tr : {
                                                     td @(class: "col-md-6"): test.name,
                                                     td @(class: "col-md-2"): {
                                                        div @(class: "container-fluid muleicon muleicon-head muleicon-skip", style: "margin-left: 0px;"): null
                                                     },
                                                     td @(class: "col-md-4"): "Skipped"
                                                }
                                            }
                                        )
                                    )
                               }
                        }//closes table
                    },
                    hr: null,
                }
            )
        }
    }
}


