%dw 2.0

import * from dw::test::Tests
import countBy from dw::core::Arrays

type TestsResult = Array<{name: String, testResult: TestResult}>

type AggregatorInput = {
 showCoverageReport: Boolean,
 testsResult: TestsResult
}

fun totalWithCriteria(testSuite: TestResult, criteria: (TEST_STATUS) -> Boolean): Number =
  if (testSuite.tests?)
    sum((testSuite.tests as Array<TestResult>) map (suite) -> totalWithCriteria(suite, criteria))
  else
    if (criteria(testSuite.status))
      1
    else
      0

fun totalWithStatus(testsuite: TestResult, statusId: String) =
  totalWithCriteria(testsuite, (stat) -> stat == statusId)

fun totalErrors(testsuite: TestResult) =
    totalWithStatus(testsuite, ERROR_STATUS)

fun totalSkip(testsuite: TestResult) =
    totalWithStatus(testsuite, SKIP_STATUS)

fun totalOk(testsuite: TestResult) =
    totalWithStatus(testsuite, OK_STATUS)

fun totalFail(testsuite: TestResult) =
    totalWithStatus(testsuite, FAIL_STATUS)

fun totalTests(testsuite: TestResult) =
  totalWithCriteria(testsuite, (s) -> true)