/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.test.runner.coverage.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.weave.v2.module.test.runner.coverage.model.CodeCoverageLine;
import org.mule.weave.v2.module.test.runner.coverage.model.NameIdentifierWrapper;

public class CodeCoverageFile {
    private static final String PATH = "path";
    private static final String NAME_IDENTIFIER = "nameIdentifier";
    private static final String LINES = "lines";
    private File file;
    private NameIdentifierWrapper nameIdentifier;
    private List<CodeCoverageLine> lines;

    public CodeCoverageFile() {
    }

    public CodeCoverageFile(File file, NameIdentifierWrapper nameIdentifier, List<CodeCoverageLine> lines) {
        this.file = file;
        this.nameIdentifier = nameIdentifier;
        this.lines = lines;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public NameIdentifierWrapper getNameIdentifier() {
        return this.nameIdentifier;
    }

    public void setNameIdentifier(NameIdentifierWrapper nameIdentifier) {
        this.nameIdentifier = nameIdentifier;
    }

    public List<CodeCoverageLine> getLines() {
        return this.lines;
    }

    public void setLines(List<CodeCoverageLine> lines) {
        this.lines = lines;
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (this.file != null) {
            map.put(PATH, this.file.getAbsolutePath());
        }
        if (this.nameIdentifier != null) {
            map.put(NAME_IDENTIFIER, this.nameIdentifier.asMap());
        }
        if (this.lines != null) {
            List linesAsMap = this.lines.stream().map(CodeCoverageLine::asMap).collect(Collectors.toList());
            map.put(LINES, linesAsMap);
        } else {
            map.put(LINES, new ArrayList(0));
        }
        return map;
    }
}

