%dw 2.0
import * from dw::test::Tests
import * from dw::core::Arrays
import * from dw::test::internal::reporter::Reports

input aggregatorInput: AggregatorInput application/json
output application/html with xml indent=false

fun testResultDetail(testSuite: TestResult) = {
  ul: {
    li: {
      (
        if (testSuite.tests?)
          if (testSuite.status == SKIP_STATUS)
            { div @(class:"text-warning"): "$(testSuite.name) ** SKIPPED **" }
          else
            (testSuite.tests as Array<TestResult>) reduce (
              childTestSuite,
              acc = {
                div @(class:"text-bold"): testSuite.name,
                span @(class:"alert-success text-bold"):
                  "Tests: executed $(totalTests(testSuite)), passed $(totalOk(testSuite)), failed $(totalFail(testSuite) + totalErrors(testSuite)), skipped $(totalSkip(testSuite))"
              }
            ) -> acc ++ testResultDetail(childTestSuite)
        else do {
          var test: TestResult = testSuite
          ---
          if (test.status == OK_STATUS)
            { span @(class:"text-success"): "$(test.name) \u2713" }
          else if (test.status == FAIL_STATUS or test.status == ERROR_STATUS)
            {
              div: {
                span @(class:"text-danger"): "$(test.name) \u2717",
                div: {
                  pre @(style: "display: inline-block"): { code: test.errorMessage }
                }
              }
            }
          else
            { span @(class:"text-warning"): "$(test.name) ** SKIPPED **" }
        }
      )
    }
  }
}
    
---
html: {
    head: {
        meta @(charset: "utf-8") : null,
        meta @(name: "viewport", content:"width=device-width, initial-scale=1, maximum-scale=1") : null,
        title: "DataWeave Testing Framework - Test Report",
        link @(rel: "stylesheet", 'type': "text/css", href: "assets/mulesoft-styles.css"): null,
        link @(rel: "stylesheet", 'type': "text/css", href: "assets/tsorter.css"): null
    },
    body: {
        header: {
             div @(class:"mulesoft-topbar"): {
                div @(class: "mulesoft-appbar"): {
                        div @(class: "muleicon muleicon-logo"): null,
                        div @(class: "anypoint-brand"): "DataWeave Testing Framework - Test Report"
                    }
                }
            },
        div @(class: "col-md-2 col-md-offset-1 sidemenu"):{
            ul @(class: "sidemenu-back"):{
                li:{
                    a @(href: ""): "Test Report"
                },
                (if (aggregatorInput.showCoverageReport) {
                  li: {
                    a @(href: "coverage/data-weave-testing-framework-coverage-report.html"): "Coverage Report"
                  }
                } else {
                })
            }
        },
        div @(class: "container col-md-8"): {
            div @(class: "container-fluid"): {
                table @(class: "table table-featured table-hover sortable", id: "summary"): {
                    thead: {
                        tr: {
                                th @(colspan: "2", "data-tsorter":"link"): "Test Suite",
                                th @("data-tsorter": "numeric"): "Passed",
                                th @("data-tsorter": "numeric"): "Failed",
                                th @("data-tsorter": "numeric"): "Skipped",
                                th @("data-tsorter": "numeric"): "Total"
                        }
                    },
                    tbody: {
                        (aggregatorInput.testsResult map (testSuite) -> {
                                tr:{
                                    td @(colspan: "2"): {
                                        a @(href: "#$(testSuite.name)"): testSuite.name
                                    },
                                    td: totalOk(testSuite.testResult),
                                    td: totalFail(testSuite.testResult) + totalErrors(testSuite.testResult),
                                    td: totalSkip(testSuite.testResult),
                                    td: totalTests(testSuite.testResult)
                                }

                            }
                        )
                    }
                }
            },
            hr: null,
            (
                aggregatorInput.testsResult map (testSuite) ->{
                div @(class: "container-fluid"): {
                    h4 @(class: "text-bold", id: "$(testSuite.name)"): testSuite.name,
                    (testResultDetail(testSuite.testResult)) 
                    },
                    hr: null,
                }
 
            )
        }
    }
}


