/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.test.runner.coverage.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.weave.v2.module.test.runner.coverage.model.CodeCoverageBranch;
import org.mule.weave.v2.parser.location.WeaveLocation;

public class CodeCoverageLine {
    private static final String BRANCHES = "branches";
    private static final String COVERED = "covered";
    private static final String LINE_NUMBER = "lineNumber";
    private WeaveLocation location;
    private List<CodeCoverageBranch> branches = new ArrayList<CodeCoverageBranch>();
    private boolean covered;

    public CodeCoverageLine() {
    }

    public CodeCoverageLine(WeaveLocation location, List<CodeCoverageBranch> branches) {
        this.location = location;
        this.branches = branches;
    }

    public WeaveLocation getLocation() {
        return this.location;
    }

    public void setLocation(WeaveLocation location) {
        this.location = location;
    }

    public List<CodeCoverageBranch> getBranches() {
        return this.branches;
    }

    public void setBranches(List<CodeCoverageBranch> branches) {
        this.branches = branches;
    }

    public boolean isCovered() {
        return this.covered;
    }

    public void setCovered(boolean covered) {
        this.covered = covered;
    }

    public int getLineNumber() {
        return this.location.startPosition().line();
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (this.branches != null) {
            List branchesAsMap = this.branches.stream().map(CodeCoverageBranch::asMap).collect(Collectors.toList());
            map.put(BRANCHES, branchesAsMap);
        } else {
            map.put(BRANCHES, new ArrayList(0));
        }
        map.put(COVERED, this.isCovered());
        map.put(LINE_NUMBER, this.getLineNumber());
        return map;
    }
}

