/**
* Generates coverage report based on https://docs.sonarqube.org/latest/analysis/generic-test/
*/
%dw 2.0
output application/xml

---
{
  coverage @(version: 1): {
    (
      payload.files map ((file, index) ->  {
        file @(path: file.path): {
          (
            file.lines map ((line) -> do {
              var hasBranches = !isEmpty(line.branches)
              ---
              {
                lineToCover @(
                  lineNumber: line.lineNumber,
                  covered: line.covered,
                  (branchesToCover: sizeOf(line.branches)) if(hasBranches),
                  (coveredBranches: sizeOf(line.branches filter $.covered)) if(hasBranches)
                ): {}
              }
            })
          )
        }
      })
    )
  }
}