%dw 2.0

type CovLine = {
  branches: Array<Object>,
  covered: Boolean
}

type File = {
  path: String,
  nameIdentifier: Object,
  lines: Array<CovLine>
}

fun getAllBranches(f: File): Array<Object> = do {
  var branchesArray = flatten((f.lines filter (!isEmpty($.branches)))..branches) default []
  ---
  branchesArray
}

fun fileCoverage(f: File): Number = do {
  var totalLines = sizeOf(f.lines) default 0
  var coveredLines = sizeOf(f.lines filter ($.covered))
  var allBranches = getAllBranches(f)
  var totalBranches = sizeOf(allBranches) default 0
  var coveredBranches = sizeOf(allBranches filter ($.covered)) default 0
  ---
   if ((totalLines + totalBranches) > 0)
    (coveredLines + coveredBranches) / (totalLines + totalBranches) * 100
   else
    0
}

fun totalCoverage(files: Array<File>): Number = do{
  var totalLines = files reduce (f, acc = 0) -> acc + sizeOf(f.lines) default 0
  var weightedCoverage = files map (f, i) -> (fileCoverage(f) * sizeOf(f.lines))
  ---
  if (totalLines > 0)
    sum(weightedCoverage)/totalLines
  else
    0
}