%dw 2.0
import countBy from dw::core::Arrays
import * from dw::test::internal::reporter::Reports


/**
* Transforms the test result in a junit compatible test result report
*/
fun processTestResult(testResult) = do {

    fun testToJunitResult(test) = do {
      if ((not test.tests?) or isEmpty(test.tests)) {
        testcase @(name: test.name, time: test.time, status: test.status): {
          (failure: test.errorMessage) if (test.status == "FAIL"),
          (error: test.errorMessage) if (test.status == "ERROR")
        }
      } else do {
        {
          testsuite @(
                    tests: totalTests(testResult),
                    time: testResult.time,
                    name: testResult.name,
                    failures: totalFail(testResult),
                    skipped: totalSkip(testResult),
                    errors: totalErrors(testResult)): {
            (test.tests map ((item, index) -> testToJunitResult(item)))
          }
        }
      }
    }
    ---
    {
        testsuites
              @(tests: totalTests(testResult),
                time: testResult.time,
                name: testResult.name,
                failures: totalFail(testResult),
                errors: totalErrors(testResult)
                ): testToJunitResult(testResult)
    }
}

output application/xml
---
processTestResult(testResult)