package org.mule.weave.v2.debugger.commands

import org.mule.weave.v2.debugger.event.DebuggerEvent
import org.mule.weave.v2.debugger.event.ScriptResultEvent

class EvaluateScriptCommand(script: String, frameId: Int = -1) extends DebuggerCommand {
  override def call(debuggerContext: WeaveDebuggerCommandInterpreter): Option[DebuggerEvent] = {
    Some(ScriptResultEvent(script, debuggerContext.evaluateScript(script, frameId)))
  }
}
