package org.mule.weave.v2.debugger.commands

import org.mule.weave.v2.debugger.WeaveExceptionBreakpoint
import org.mule.weave.v2.debugger.event.DebuggerEvent
import org.mule.weave.v2.debugger.event.ExceptionBreakpointsAddedEvent

class AddExceptionBreakpointsCommand(val breakpoints: Array[WeaveExceptionBreakpoint]) extends DebuggerCommand {
  override def call(debuggingSession: WeaveDebuggerCommandInterpreter): Option[DebuggerEvent] = {
    debuggingSession.addExceptionBreakpoint(breakpoints)
    Some(ExceptionBreakpointsAddedEvent(breakpoints))
  }
}
