package org.mule.weave.v2.debugger.client

import org.mule.weave.v2.debugger.commands.ClientCommand
import org.mule.weave.v2.debugger.event.RemoteServerMessage
import org.mule.weave.v2.debugger.event.UnexpectedServerErrorEvent

trait ClientProtocol {

  def sendCommand[ContextType, RemoteServerResponse <: RemoteServerMessage](command: ClientCommand[ContextType, RemoteServerResponse]): String

  def connect(): Unit

  def disconnect(): Unit

  def isConnected(): Boolean

  def addServerMessageHandler[T <: RemoteServerMessage](clazz: Class[_], handler: ServerMessageHandler[T])
}

trait ServerMessageHandler[T <: RemoteServerMessage] {
  type TypeOfMessage = T

  def handleUnexpectedError(unexpectedServerErrorEvent: UnexpectedServerErrorEvent) = {}

  def handle(message: TypeOfMessage)
}

